/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	E-mail de l'auteur : contact@i-services.net
*********************************************************************/

/* Fonctions jQuery pour les formulaires */

$(function() {
	$('.jq-insert-url').click(function() {
		$("#is-url-insert").appendTo($(this).next('.is-url-insert'));

		var html = '<dl class="form-inline">';
		html += '<dt>Insérer une URL <img class="is-close" src="' + base_url + 'img/design/icons/msg-box-close.png" alt=""></dt>';
		html += '<dd class="is-url-field"><label for="is-url">URL :</label> <input type="text" id="is-url" name="tool_insert_url" maxlength="200" value="http://" class="form-control input-sm"></dd>';
		html += '<dd class="is-url-field"><label for="is-email">Ou adresse e-mail :</label> <input type="text" id="is-email" name="tool_insert_email" maxlength="50" value="" class="form-control input-sm"></dd>';
		html += '<dd class="is-url-field"><label for="is-texte">Texte du lien :</label> <input type="text" id="is-texte" name="tool_insert_texte" maxlength="50" value="" class="form-control input-sm"></dd>';
		html += '<dd class="is-url-submit"><button class="btn btn-default"><i class="fal fa-link"></i> Insérer</button></dd>';
		html += '</dl>';

		$('#is-url-insert').html(html);

		html = null;

		$('#is-url-insert .is-close').click(function() {
			$('#is-url-insert').html("");
		});

		$('#is-url-insert dl')
		.find('dd.is-url-submit button').click(function() {
			var url = $(this).parents('dl').find('input[name=tool_insert_url]').val();
			var email = $(this).parents('dl').find('input[name=tool_insert_email]').val();
			var texte = $(this).parents('dl').find('input[name=tool_insert_texte]').val();
			var bbcode = $('#is-url-insert').parents('.is-toolbar').hasClass('is-bbcode-insert') ? true : false;

			var textarea = $('#is-url-insert').parent().parent().next('textarea');

			if(bbcode)
			{
				if(texte != '')
				{
					if(email != '')
					{
						textarea.insertStringIntoTextarea('[EMAIL=' + email + ']' + texte + '[/EMAIL]');
					}
					else
					{
						textarea.insertStringIntoTextarea('[URL=' + url + ']' + texte + '[/URL]');
					}
				}
				else
				{
					if(email != '')
					{
						textarea.insertStringIntoTextarea('[EMAIL]' + email + '[/EMAIL]');
					}
					else
					{
						textarea.insertStringIntoTextarea('[URL]' + url + '[/URL]');
					}
				}
			}
			else
			{
				if(texte != '')
				{
					if(email != '')
					{
						textarea.insertStringIntoTextarea('<a href="mailto:' + email + '">' + texte + '</a>');
					}
					else
					{
						textarea.insertStringIntoTextarea('<a href="' + url + '">' + texte + '</a>');
					}
				}
				else
				{
					if(email != '')
					{
						textarea.insertStringIntoTextarea('<a href="mailto:' + email + '">' + email + '</a>');
					}
					else
					{
						textarea.insertStringIntoTextarea('<a href="' + url + '">' + url + '</a>');
					}
				}
			}

			$('#is-url-insert').html("");

			return false;
		});

		return false;
	});

	$('form input, form textarea').focus(function() {
		if($('#is-url-insert').length > 0)
		{
			$('#is-url-insert').html("");
		}
	});
});