/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

$(function() {
	$("[data-target=\"#ConfirmationModal\"]").click(function(e) {
		e.preventDefault();

		$("#ConfirmationModal .modal-body").html($(this).data("content"));

		if($(this).data('action') == 'redirect')
		{
			$("#ConfirmationModal .jq-confirm-alert-box").data("location", $(this).data("href"));
		}
		else if($(this).data('action') == 'submit')
		{
			$("#ConfirmationModal .jq-confirm-alert-box").data("submit-form", $(this).data('form-id'));

			if($(this).is('[data-choice]') == true)
			{
				$("#ConfirmationModal .jq-confirm-alert-box").attr("data-choice", $(this).data('choice'));
			}
		}
	});

	$("#ConfirmationModal .jq-confirm-alert-box").click(function() {
		if($(this).data("location") != '')
		{
			var page_location = $(this).data("location");

			$(location).attr("href", page_location);
		}
		else if($(this).data("submit-form") != '' && $('#' + $(this).data("submit-form")).length)
		{
			if($(this).is('[data-choice]') == true)
			{
				$('#' + $(this).data("submit-form") + ' input[name^=formChoice]').val( $(this).data('choice') );
			}

			$('#' + $(this).data("submit-form")).submit();
		}
	});

	$("a.jq-dialog-message").click(function(e){
			e.preventDefault();

			$("#dialog-message").remove();
			$('body').append('<div id="dialog-message"></div>');

			$("#dialog-message")
			.attr('title', $(this).attr('title'))
			.html('<p>' + $(this).data('message') + '</p>')
			.dialog({
			width: Math.min(450, $(window).width() - 20),
			modal: true,
			buttons: {
				Ok: function() {
					$(this).dialog("close");
				}
			}
		});
	});

	$("a.jq-dialog-confirm").click(function(e){
			e.preventDefault();

			$("#dialog-confirm").remove();
			$('body').append('<div id="dialog-confirm"></div>');

			var href = $(this).attr('href');

			$("#dialog-confirm")
			.attr('title', "Confirmation")
			.html('<p>' + $(this).data('message') + '</p>')
			.dialog({
			resizable: false,
			width: Math.min(450, $(window).width() - 20),
			modal: true,
			 buttons: {
				"OK": function() {
					$(location).attr('href', href);
				},
				"Annuler": function() {
					$(this).dialog("close");
					}
				}
		});
	});
});