/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

$.fn.freeEmailWarning = function() {
	var form_group = this.closest(".form-group");

	if(form_group.length)
	{
		if(strstr(this.val().toLowerCase(), "@free.fr") || strstr(this.val().toLowerCase(), "@yahoo.fr"))
		{
			if(!$(".free-email-warning", form_group).length)
			{
				form_group.append("<div class=\"alert alert-sm alert-warning help-block free-email-warning\"><i class=\"fal fa-exclamation-circle\"></i> Les fournisseurs de messagerie tels que Free.fr ou Yahoo.fr sont réputés pour avoir une politique anti-spam très agressive. Afin de vous assurer de recevoir les mails en provenance de notre site nous vous invitons à utiliser dans la mesure du possible une adresse e-mail d'un autre fournisseur (Gmail, Laposte.net, etc.)</div>");
			}

			$(".free-email-warning", form_group).show();
		}
		else
		{
			if($(".free-email-warning", form_group).length)
			{
				$(".free-email-warning", form_group).hide();
			}
		}
	}
};

$(function() {
	$("form button").click(function(e) {
		e.preventDefault();
	});

	$("form input:text").focus(function() {
		$(this).select();
	});

	$("form button.is-form-action-button:not(.is-submit-btn)").click(function() {
		var button_text = $(this).text();
		var form_id = $(this).closest('form').attr('id');

		if(strstr(button_text, 'Annuler') && form_id != 'post_comment' && form_id != 'share_form')
		{
			$(location).attr("href", $("link[rel=canonical]").attr("href"));
		}
	});

	$("form button.is-submit-btn").click(function() {
		var form = $(this).closest('form');

		if($(this).is(":contains(\'Patientez...\')") == false)
		{
			form.submit();
		}
	});

	if($("form input[name=formAnchor]").length && $("form input[name=formAnchor]").val() != "")
	{
		var anchor = $("form input[name=formAnchor]").val();

		window.location.hash = anchor;

		if($(anchor).length && $('.jq-alert-msg').length == 0)
		{
			$('html, body').animate({scrollTop:$(anchor).offset().top}, 'fast');
		}

		$("form input[name=formAnchor]").val('');
	}

	$('form select.reload-form').change(function() {
		var form = $(this).closest('form');

		if($('input[name=reload]', form).length)
		{
			$('input[name=reload]', form).val(1);
		}
		else
		{
			$('input[name^=formReloaded]', form).val(1);

			if($("input[name=formAnchor]", form).length)
			{
				$("input[name=formAnchor]", form).val( "#" + $(this).attr("id") );
			}
		}

		form.submit();
	});

	$('form input[type=radio].reload-form, form input[type=checkbox].reload-form').click(function() {
		var form = $(this).closest('form');

		if($('input[name=reload]', form).length)
		{
			$('input[name=reload]', form).val(1);
		}
		else
		{
			$('input[name^=formReloaded]', form).val(1);

			if($("input[name=formAnchor]", form).length)
			{
				$("input[name=formAnchor]", form).val( "#" + $(this).attr("id") );
			}
		}

		form.submit();
	});

	$('form input[type=text].reload-form, form input[type=password].reload-form, form textarea.reload-form').blur(function() {
		var form = $(this).closest('form');

		if($('input[name=reload]', form).length)
		{
			$('input[name=reload]', form).val(1);
		}
		else
		{
			$('input[name^=formReloaded]', form).val(1);

			if($("input[name=formAnchor]", form).length)
			{
				$("input[name=formAnchor]", form).val( "#" + $(this).attr("id") );
			}
		}

		form.submit();
	});

	$('.btn-file input:file').change(function() {
		 var selected_file_text = $(this).parent().next('.selected-file-text');

		 if(selected_file_text.length)
		 {
			selected_file_text.html($(this).val().replace("C:\\fakepath", "<i class=\"fal fa-hdd\"></i>"));
		 }
	});

	/* Input calendar and date picker */

	$("input.jq-datetime-picker, input.jq-date-picker, input.jq-time-picker").next('.input-group-addon').children('a.jq-input-calendar').click(function() {
		$(this).parent('.input-group-addon').prev("input").trigger('focus');

		return false;
	});

	$('input.jq-datetime-picker:not([readonly])').datetimepicker({
		dayOfWeekStart: 1,
		lang:'fr',
		startDate:	$(this).val(),
		datepicker: true,
		timepicker: true,
		format:	'd/m/Y H:i:s',
		yearStart: new Date().getFullYear() - 50,
		yearEnd: new Date().getFullYear() + 10,
		step: 15
	});

	$('input.jq-time-picker:not([readonly])').datetimepicker({
		datepicker: false,
		timepicker: true,
		lang:'fr',
		startDate:	$(this).val(),
		format:	'H:i:s',
		step: 15
	});

	$('input.jq-date-picker:not([readonly])').datetimepicker({
		dayOfWeekStart: 1,
		lang:'fr',
		startDate:	$(this).val(),
		datepicker: true,
		timepicker:false,
		yearStart: new Date().getFullYear() - 50,
		yearEnd: new Date().getFullYear() + 10,
		format:	'd/m/Y'
	});

	$("form textarea.autosize").autosize({append: "\n"});

	$("form label img").click(function() {
		var id_radio = $(this).parent().attr("for");

		$("#" + id_radio).prop("checked", true);
	});

	$(".captcha-input").attr("autocomplete", "off");

	/* Editeur BBcode - DEBUT */

	$("form .is-toolbar a.jq-toolbar-insert:not(.jq-upload-img)").click(function(e) {
		e.preventDefault();

		if($(this).hasClass('jq-insert-img')) return false;
		if($(this).hasClass('jq-insert-video')) return false;
		if($(this).hasClass('jq-insert-audio')) return false;
		if($(this).hasClass('jq-insert-url')) return false;

		var textarea = $(this).parent('.is-toolbar').next();
		var bbcode = $(this).parent('.is-toolbar').hasClass('is-bbcode-insert') ? true : false;
		var openTag;
		var closeTag;

		if(strstr($(this).attr('title'), 'Insérer une vidéo'))
		{
			openTag = bbcode ? '[VIDEO]' : '<span data-video="';
			closeTag = bbcode ? '[/VIDEO]' : '"></span>';
		}
		else if(strstr($(this).attr('title'), 'Insérer un fichier audio'))
		{
			openTag = bbcode ? '[AUDIO]' : '<span data-audio="';
			closeTag = bbcode ? '[/AUDIO]' : '"></span>';
		}
		else
		{
			switch($(this).attr('title'))
			{
				case 'Gras' : openTag = bbcode ? '[B]' : '<b>';
							  closeTag = bbcode ? '[/B]' : '</b>'; break;

				case 'Italique' : openTag = bbcode ? '[I]' : '<i>';
								  closeTag = bbcode ? '[/I]' : '</i>'; break;

				case 'Souligné' : openTag = bbcode ? '[U]' : '<u>';
								  closeTag = bbcode ? '[/U]' : '</u>'; break;

				case 'Justifié' : openTag = bbcode ? '[P=JUSTIFY]' : '<p style="text-align: justify;">';
								  closeTag = bbcode ? '[/P]' : '</p>'; break;

				case 'Centré' : openTag = bbcode ? '[P=CENTER]' : '<p style="text-align: center;">';
								closeTag = bbcode ? '[/P]' : '</p>'; break;

				case 'Aligné à droite' : openTag = bbcode ? '[P=RIGHT]' : '<p style="text-align: right;">';
										 closeTag = bbcode ? '[/P]' : '</p>'; break;

				case 'Aligné à gauche' : openTag = bbcode ? '[P=LEFT]' : '<p style="text-align: left;">';
										 closeTag = bbcode ? '[/P]' : '</p>'; break;

				case 'Saut de ligne' : 	 openTag = bbcode ? "\n[BR]\n" : "\n<br />\n";
										 closeTag = bbcode ? '' : ''; break;

				case 'Insérer un lien' : openTag = bbcode ? '[URL]' : '<a href="http://adresse-de-votre-lien" target="_blank">';
										 closeTag = bbcode ? '[/URL]' : '</a>'; break;

				case 'Insérer une image' : openTag = bbcode ? '[IMG]' : '<img src="';
										   closeTag = bbcode ? '[/IMG]' : '" alt="" />'; break;

				case 'Citation' : openTag = bbcode ? '[QUOTE]' : '<blockquote class="is-quote"><b>Citation :</b> ';
							      closeTag = bbcode ? '[/QUOTE]' : '</blockquote>'; break;

				case 'Spoiler' : openTag = bbcode ? '[SPOILER]' : '<details class="spoiler"> ';
							      closeTag = bbcode ? '[/SPOILER]' : '</details>'; break;

				default : return;
			}
		}

		textarea.insertTagsIntoTextarea(openTag, closeTag);
	});

	/* Editeur BBcode - FIN */

	$("form input.alert-free-email").each(function() {
		$(this).freeEmailWarning();
	}).keyup(function() {
		$(this).freeEmailWarning();
	});
});