/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

$.fn.selectText = function(){
    this.find('input').each(function() {
        if($(this).prev().length == 0 || !$(this).prev().hasClass('p_copy')) {
            $('<p class="p_copy" style="position: absolute; z-index: -1;"></p>').insertBefore($(this));
        }
        $(this).prev().html($(this).val());
    });
    var doc = document;
    var element = this[0];
    console.log(this, element);
    if (doc.body.createTextRange) {
        var range = document.body.createTextRange();
        range.moveToElementText(element);
        range.select();
    } else if (window.getSelection) {
        var selection = window.getSelection();
        var range = document.createRange();
        range.selectNodeContents(element);
        selection.removeAllRanges();
        selection.addRange(range);
    }
};

/* Fonctions jQuery pour les formulaires */

$.fn.insertTagsIntoTextarea = function(openTag, closeTag) {
	var len = this.val().length;
	var start = this[0].selectionStart;
	var end = this[0].selectionEnd;
	var selectedText = this.val().substring(start, end);
	var replacement = openTag + selectedText + closeTag;
	this.val(this.val().substring(0, start) + replacement + this.val().substring(end, len));

	var caret = (replacement.length - closeTag.length) + start;

	setCaretPosition(this[0], caret);
};

$.fn.insertStringIntoTextarea = function(string) {
	var len = this.val().length;
	var start = this[0].selectionStart;
	var end = this[0].selectionEnd;
	var selectedText = this.val().substring(start, end);
	var replacement = selectedText + string;
	this.val(this.val().substring(0, start) + replacement + this.val().substring(end, len));

	var caret = replacement.length + start;

	setCaretPosition(this[0], caret);
};

$.fn.shuffleElements = function() {
	var allElems = this.get(),
		getRandom = function(max) {
			return Math.floor(Math.random() * max);
		},
		shuffled = $.map(allElems, function(){
			var random = getRandom(allElems.length),
				randEl = $(allElems[random]).clone(true)[0];
			allElems.splice(random, 1);
			return randEl;
	   });

	this.each(function(i){
		$(this).replaceWith($(shuffled[i]));
	});

	return $(shuffled);
};

$.fn.hasAttr = function(name) {
   return this.attr(name) !== undefined;
};

$.fn.preload_img = function() {
    this.each(function(){
        $('<img/>')[0].src = this;
    });
}

$.expr[":"].i_contains = $.expr.createPseudo(function(arg) {
    return function( elem ) {
        return $(elem).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
    };
});

window.closeModalFromIframe = function(iframe) {
    $('#' + iframe).modal('hide');
};

$(function() {
	$('.navbar .dropdown-menu').each(function() {
		if($('li', this).length > 20)
		{
			$(this).css({maxHeight: '400px', overflowX: 'auto'});
		}
	});

	$("form a.is-submit-btn").click(function(e) {
		e.preventDefault();

		var form = $(this).closest('form');

		form.submit();
	});

	$("#is-page kbd").prepend('<i class="fal fa-keyboard"></i> ');

	/* $('a.fancybox:not([data-fancybox])').removeClass('fancybox').attr('data-caption', function() {
		if($(this).hasAttr('title'))
		{
			return $(this).attr('title');
		}
	}).attr('data-fancybox', function() {
		if($(this).hasAttr('rel'))
		{
			return $(this).attr('rel');
		}
		else
		{
			return 'group';
		}
	});

	$('.ckeditor-rendered').find('img.fancybox').removeClass('fancybox').unwrap('a').wrap(function() {
		var img_caption = "";

		if($(this).hasAttr('title') && $(this).attr('title') != "")
		{
			img_caption = $(this).attr('title');
		}
		else if($(this).hasAttr('alt') && $(this).attr('alt') != "")
		{
			img_caption = $(this).attr('alt');
		}

		return '<a href="' + $(this).attr('src') + '" data-caption="' + img_caption + '" data-fancybox="group"></a>';
	}); */

	$(".ckeditor-rendered").find('img.fancybox').removeClass('fancybox').unwrap('a').wrap(function() {
		return '<a href="' + $(this).attr('src') + '" class="fancybox" rel="pictures"></a>';
	});

	$("blockquote.is-quote b:first-child").addClass("is-label");

	$(".select-image-link").click(function(e) {
	    e.preventDefault();

	    $(this).parent().find(".image-link").show().selectText();

	    document.execCommand("copy");

	    $(this).parent().find(".image-link").hide();

	    alert("L\'URL de l\'image a été copiée dans votre presse-papier !");
    });

	$("a[href=\"#\"]").click(function(e) {
		e.preventDefault();
	});

	$('details.spoiler').attr('open', true).wrapInner('<main></main>').prepend('<summary style="cursor: help;"><i class="fal fa-eye-slash"></i> Spoiler ...</summary>');
	$('details.spoiler main').hide();
	$('details.spoiler').click(function(e) { e.preventDefault(); $(this).children('main').toggle(); });

	$('#_checkAll').click(function() {
		var form = $(this).closest('form');

		if($(this).is(":checked"))
		{
			$("input:checkbox[name^=idChecked]:not(:disabled)", form).prop("checked", true);
		}
		else
		{
			$("input:checkbox[name^=idChecked]:not(:disabled)", form).prop("checked", false);
		}
	});

	$('.is-spreadsheet [id^=idChecked_]').click(function() {
		var form = $('#_checkAll').closest('form');

		$('#_checkAll').prop("checked", false);
	});

	$('p.alert button.close').click(function() {
		$(this).closest('p.alert').remove();
	});

	$('a.target-blank:not([href="#"])').click(function(e) {
		e.preventDefault();

		window.open($(this).attr('href'));
	});

	$('.jq-targets-blank a:not([target])').filter(function() { return $(this).attr('href').substring(0, 4) == 'http'; }).attr('target', 'blank');

	$('a.fetch-anchor').click(function(e) {
        e.preventDefault();
		var anchor = $(this).attr("href");

		if(anchor != '#' && $(anchor).length)
		{
			$('html, body').animate({scrollTop:$(anchor).offset().top - 150}, 'slow');
		}
	});

    $(window).scroll(function() {
		if($(this).scrollTop() > 250)
		{
			$('.back-to-top').fadeIn(300);
		}
		else
		{
			$('.back-to-top').fadeOut(300);
		}
	});

	if($(window).scrollTop() > 250)
	{
		$('.back-to-top').show();
	}
	else
	{
		$('.back-to-top').hide();
	}

	$('.back-to-top').click(function(e) {
        e.preventDefault();
        $('html, body').animate({scrollTop: 0}, 300);
    });

	$('[data-toggle="popover"]').popover({ trigger: "manual" , html: true, animation:false})
    .on("mouseenter", function() {
        var _this = this;
        $(this).popover("show");
        $(".popover").on("mouseleave", function() {
            $(_this).popover('hide');
        });
    }).on("mouseleave", function() {
        var _this = this;
        setTimeout(function() {
            if (!$(".popover:hover").length) {
                $(_this).popover("hide");
            }
        }, 300);
	 });
});