
CKEDITOR.dialog.add('ckawesomeDialog', function( editor ) {
	var brandsIcons = ["fa-500px", "fa-accessible-icon", "fa-accusoft", "fa-acquisitions-incorporated", "fa-adn", "fa-adobe", "fa-adversal", "fa-affiliatetheme", "fa-airbnb", "fa-algolia", "fa-alipay", "fa-amazon", "fa-amazon-pay", "fa-amilia", "fa-android", "fa-angellist", "fa-angrycreative", "fa-angular", "fa-app-store", "fa-app-store-ios", "fa-apper", "fa-apple", "fa-apple-pay", "fa-artstation", "fa-asymmetrik", "fa-atlassian", "fa-audible", "fa-autoprefixer", "fa-avianex", "fa-aviato", "fa-aws", "fa-bandcamp", "fa-battle-net", "fa-behance", "fa-behance-square", "fa-bimobject", "fa-bitbucket", "fa-bitcoin", "fa-bity", "fa-black-tie", "fa-blackberry", "fa-blogger", "fa-blogger-b", "fa-bluetooth", "fa-bluetooth-b", "fa-bootstrap", "fa-btc", "fa-buffer", "fa-buromobelexperte", "fa-buysellads", "fa-canadian-maple-leaf", "fa-cc-amazon-pay", "fa-cc-amex", "fa-cc-apple-pay", "fa-cc-diners-club", "fa-cc-discover", "fa-cc-jcb", "fa-cc-mastercard", "fa-cc-paypal", "fa-cc-stripe", "fa-cc-visa", "fa-centercode", "fa-centos", "fa-chrome", "fa-chromecast", "fa-cloudscale", "fa-cloudsmith", "fa-cloudversify", "fa-codepen", "fa-codiepie", "fa-confluence", "fa-connectdevelop", "fa-contao", "fa-cpanel", "fa-creative-commons", "fa-creative-commons-by", "fa-creative-commons-nc", "fa-creative-commons-nc-eu", "fa-creative-commons-nc-jp", "fa-creative-commons-nd", "fa-creative-commons-pd", "fa-creative-commons-pd-alt", "fa-creative-commons-remix", "fa-creative-commons-sa", "fa-creative-commons-sampling", "fa-creative-commons-sampling-plus", "fa-creative-commons-share", "fa-creative-commons-zero", "fa-critical-role", "fa-css3", "fa-css3-alt", "fa-cuttlefish", "fa-d-and-d", "fa-d-and-d-beyond", "fa-dashcube", "fa-delicious", "fa-deploydog", "fa-deskpro", "fa-dev", "fa-deviantart", "fa-dhl", "fa-diaspora", "fa-digg", "fa-digital-ocean", "fa-discord", "fa-discourse", "fa-dochub", "fa-docker", "fa-draft2digital", "fa-dribbble", "fa-dribbble-square", "fa-dropbox", "fa-drupal", "fa-dyalog", "fa-earlybirds", "fa-ebay", "fa-edge", "fa-elementor", "fa-ello", "fa-ember", "fa-empire", "fa-envira", "fa-erlang", "fa-ethereum", "fa-etsy", "fa-evernote", "fa-expeditedssl", "fa-facebook", "fa-facebook-f", "fa-facebook-messenger", "fa-facebook-square", "fa-fantasy-flight-games", "fa-fedex", "fa-fedora", "fa-figma", "fa-firefox", "fa-first-order", "fa-first-order-alt", "fa-firstdraft", "fa-flickr", "fa-flipboard", "fa-fly", "fa-font-awesome", "fa-font-awesome-alt", "fa-font-awesome-flag", "fa-fonticons", "fa-fonticons-fi", "fa-fort-awesome", "fa-fort-awesome-alt", "fa-forumbee", "fa-foursquare", "fa-free-code-camp", "fa-freebsd", "fa-fulcrum", "fa-galactic-republic", "fa-galactic-senate", "fa-get-pocket", "fa-gg", "fa-gg-circle", "fa-git", "fa-git-square", "fa-github", "fa-github-alt", "fa-github-square", "fa-gitkraken", "fa-gitlab", "fa-gitter", "fa-glide", "fa-glide-g", "fa-gofore", "fa-goodreads", "fa-goodreads-g", "fa-google", "fa-google-drive", "fa-google-play", "fa-google-plus", "fa-google-plus-g", "fa-google-plus-square", "fa-google-wallet", "fa-gratipay", "fa-grav", "fa-gripfire", "fa-grunt", "fa-gulp", "fa-hacker-news", "fa-hacker-news-square", "fa-hackerrank", "fa-hips", "fa-hire-a-helper", "fa-hooli", "fa-hornbill", "fa-hotjar", "fa-houzz", "fa-html5", "fa-hubspot", "fa-imdb", "fa-instagram", "fa-intercom", "fa-internet-explorer", "fa-invision", "fa-ioxhost", "fa-itch-io", "fa-itunes", "fa-itunes-note", "fa-java", "fa-jedi-order", "fa-jenkins", "fa-jira", "fa-joget", "fa-joomla", "fa-js", "fa-js-square", "fa-jsfiddle", "fa-kaggle", "fa-keybase", "fa-keycdn", "fa-kickstarter", "fa-kickstarter-k", "fa-korvue", "fa-laravel", "fa-lastfm", "fa-lastfm-square", "fa-leanpub", "fa-less", "fa-line", "fa-linkedin", "fa-linkedin-in", "fa-linode", "fa-linux", "fa-lyft", "fa-magento", "fa-mailchimp", "fa-mandalorian", "fa-markdown", "fa-mastodon", "fa-maxcdn", "fa-medapps", "fa-medium", "fa-medium-m", "fa-medrt", "fa-meetup", "fa-megaport", "fa-mendeley", "fa-microsoft", "fa-mix", "fa-mixcloud", "fa-mizuni", "fa-modx", "fa-monero", "fa-napster", "fa-neos", "fa-nimblr", "fa-nintendo-switch", "fa-node", "fa-node-js", "fa-npm", "fa-ns8", "fa-nutritionix", "fa-odnoklassniki", "fa-odnoklassniki-square", "fa-old-republic", "fa-opencart", "fa-openid", "fa-opera", "fa-optin-monster", "fa-osi", "fa-page4", "fa-pagelines", "fa-palfed", "fa-patreon", "fa-paypal", "fa-penny-arcade", "fa-periscope", "fa-phabricator", "fa-phoenix-framework", "fa-phoenix-squadron", "fa-php", "fa-pied-piper", "fa-pied-piper-alt", "fa-pied-piper-hat", "fa-pied-piper-pp", "fa-pinterest", "fa-pinterest-p", "fa-pinterest-square", "fa-playstation", "fa-product-hunt", "fa-pushed", "fa-python", "fa-qq", "fa-quinscape", "fa-quora", "fa-r-project", "fa-raspberry-pi", "fa-ravelry", "fa-react", "fa-reacteurope", "fa-readme", "fa-rebel", "fa-red-river", "fa-reddit", "fa-reddit-alien", "fa-reddit-square", "fa-redhat", "fa-renren", "fa-replyd", "fa-researchgate", "fa-resolving", "fa-rev", "fa-rocketchat", "fa-rockrms", "fa-safari", "fa-salesforce", "fa-sass", "fa-schlix", "fa-scribd", "fa-searchengin", "fa-sellcast", "fa-sellsy", "fa-servicestack", "fa-shirtsinbulk", "fa-shopware", "fa-simplybuilt", "fa-sistrix", "fa-sith", "fa-sketch", "fa-skyatlas", "fa-skype", "fa-slack", "fa-slack-hash", "fa-slideshare", "fa-snapchat", "fa-snapchat-ghost", "fa-snapchat-square", "fa-soundcloud", "fa-sourcetree", "fa-speakap", "fa-speaker-deck", "fa-spotify", "fa-squarespace", "fa-stack-exchange", "fa-stack-overflow", "fa-staylinked", "fa-steam", "fa-steam-square", "fa-steam-symbol", "fa-sticker-mule", "fa-strava", "fa-stripe", "fa-stripe-s", "fa-studiovinari", "fa-stumbleupon", "fa-stumbleupon-circle", "fa-superpowers", "fa-supple", "fa-suse", "fa-symfony", "fa-teamspeak", "fa-telegram", "fa-telegram-plane", "fa-tencent-weibo", "fa-the-red-yeti", "fa-themeco", "fa-themeisle", "fa-think-peaks", "fa-trade-federation", "fa-trello", "fa-tripadvisor", "fa-tumblr", "fa-tumblr-square", "fa-twitch", "fa-twitter", "fa-twitter-square", "fa-typo3", "fa-uber", "fa-ubuntu", "fa-uikit", "fa-uniregistry", "fa-untappd", "fa-ups", "fa-usb", "fa-usps", "fa-ussunnah", "fa-vaadin", "fa-viacoin", "fa-viadeo", "fa-viadeo-square", "fa-viber", "fa-vimeo", "fa-vimeo-square", "fa-vimeo-v", "fa-vine", "fa-vk", "fa-vnv", "fa-vuejs", "fa-waze", "fa-weebly", "fa-weibo", "fa-weixin", "fa-whatsapp", "fa-whatsapp-square", "fa-whmcs", "fa-wikipedia-w", "fa-windows", "fa-wix", "fa-wizards-of-the-coast", "fa-wolf-pack-battalion", "fa-wordpress", "fa-wordpress-simple", "fa-wpbeginner", "fa-wpexplorer", "fa-wpforms", "fa-wpressr", "fa-xbox", "fa-xing", "fa-xing-square", "fa-y-combinator", "fa-yahoo", "fa-yammer", "fa-yandex", "fa-yandex-international", "fa-yarn", "fa-yelp", "fa-yoast", "fa-youtube", "fa-youtube-square", "fa-zhihu"];

	function getCKAwesomeIcons(selectList ){
	     var result = [];
	     var scriptUrl = editor.fontawesomePath;

	     $.ajax({
	        url: scriptUrl,
	        type: 'get',
	        dataType: 'html',
	        async: false,
	        success: function(response) {
	        	var excludeStyles = [".fa.",".fa",".fas",".fal",".far",".fab",".fa-lg",".fa-1x",".fa-2x",".fa-3x",".fa-4x",".fa-5x",".fa-6x",".fa-7x",".fa-8x",".fa-9x",".fa-10x",".fa-fw",".fa-ul",".fa-ul>",".fa-li",".fa-border",".fa-pull-left",".fa-pull-right",".fa-spin",".fa-pulse",".fa-rotate-90",".fa-rotate-180",".fa-rotate-270",".fa-flip-horizontal",".fa-flip-vertical",".fa-stack",".fa-stack-1x",".fa-stack-2x",".fa-inverse"];

	        	var regxstyles = new RegExp(/\.[a-zA-Z_][\w-_]*[^\.\s\{#:\,;]/,"g" );
	        	var styles = response.match(regxstyles);
	        	styles.sort();
	        	$.each(styles, function( index, value ) {
	        		var xstart=value.substring(0, 3).substring(1);
	        		if (xstart != 'fa' || excludeStyles.indexOf(value) >= 0) { return; }
	        		value = value.substring(1);
					// alert(value);
	        		selectList.add(value, value);
	        	})

	        },
	        error: function (jqXHR, exception) {
	            alert("Error loading Font Awesome css: \n" + scriptUrl);
	        },
	     });
	}

	function getSelectionOptions(selectList, start, inc, many){
	    var result = [];
	    var val = start;

	    result.push(start);

	    many = many > 0 ? many : 5;
	    for(var i = 0; i < many; i++){
	    	val += inc;
	    	result.push(val);
	    }

	    $.each(result, function( index, value ) {
	   		selectList.add(value, value);
	   	})
	}

	function formatCKAwesome (icon) {
	  if (!icon.id) { return icon.text; }
	  var text = icon.text.replace(/fa-|\.|\-/gi, " ");
	  // var icon = $('<span><i class="fa ' + icon.element.value + ' fa-fw"></i> ' + text + "</span>");

	  /* Icônes du menu SELECT */

	  if(brandsIcons.indexOf(icon.element.value) >= 0)
	  {
		  var icon = $('<span><i class="fab ' + icon.element.value + '"></i> ' + text + "</span>");
	  }
	  else
	  {
		  var icon = $('<span><i class="fa ' + icon.element.value + '"></i> ' + text + "</span>");
	  }

	  return icon;
	};

    return {
        title: 'Insert CKAwesome',
        minWidth: 200,
        minHeight: 200,

        contents: [
            {
                id: 'options',
                label: 'Basic Settings',
                elements: [
                    {
					    type: 'select',
					    id: 'ckawesomebox',
					    label: 'Choisir une icône Font Awesome',
					    validate: CKEDITOR.dialog.validate.notEmpty( "Veuillez sélectionner une icône Font Awesome !" ),
					    items: [[ editor.lang.common.notSet, '' ]],
					    onLoad: function () {
						   	getCKAwesomeIcons(this);
						   	var selectbx = $('#' + this.getInputElement().getAttribute('id'));
						   	$(selectbx).select2({ width: "100%", templateResult: formatCKAwesome, templateSelection: formatCKAwesome});
					    },
					    onShow: function(){
					    	var selectbx = $('#' + this.getInputElement().getAttribute('id'));
					    	$(selectbx).val('').trigger('change') ;
					    }
                    },
                    // {
                        // type: 'select',
                        // id: 'textsize',
                        // label: 'Select size',
                        // items: [[ editor.lang.common.notSet, '' ]],
                        // onLoad: function (widget) {
                        	// getSelectionOptions(this, 8, 1, 42);
                        // }
                    // },
                    {
                        type: "hbox",
                        padding: 0,
                        widths: ["80%", "20%"],
                        children: [
                            {
                                id: 'fontcolor',
                                type: 'text',
                                label: 'Choisir une couleur',
                                onChange: function( element ) {
                                	var idEl = $('#' +this.getInputElement().getAttribute('id'));
                                	idEl.css("background-color", idEl.val());
                                },
                                onKeyUp: function( element ) {
                                	var idEl = $('#' + this.getInputElement().getAttribute('id'));
                                	idEl.css("background-color", idEl.val());
                                },
        					    onShow: function(){
        					    	var idEl = $('#' + this.getInputElement().getAttribute('id'));
                                	idEl.css("background-color", "");
        					    }
                            },
                            {
                                type: "button",
                                id: "fontcolorChooser",
                                "class": "colorChooser",
                                label: "Couleur",
                                style: "margin-left: 8px",
                                onLoad: function () {
                                    this.getElement().getParent().setStyle("vertical-align", "bottom")
                                },
                                onClick: function () {
                                    editor.getColorFromDialog(function (color) {
                                        color && this.getDialog().getContentElement("options", "fontcolor").setValue( color );
                                        this.focus()
                                    }, this)
                                }
                            }
                        ]
                    }
                ]
            },
        ],
        onOk: function() {
            var dialog = this;

            var cka = editor.document.createElement( 'span' );
            // var cka_size = dialog.getValueOf( 'options', 'textsize' );
			var cka_size = '';
            var cka_color = dialog.getValueOf( 'options', 'fontcolor' );
			var faw_icon = dialog.getValueOf( 'options', 'ckawesomebox' );
            // var cka_class = "fa fa-fw " + dialog.getValueOf( 'options', 'ckawesomebox' );

			if(brandsIcons.indexOf(faw_icon) >= 0)
			{
				var cka_class = "fab " + faw_icon;
			}
			else
			{
				var cka_class = "fa " + faw_icon;
			}

            var cka_style = ( cka_size != '' ? 'font-size: '+cka_size+'px;' : '' ) + ( cka_color != '' ? 'color: '+cka_color+';' : '' ) ;

            cka.setAttribute( 'class', cka_class );
            if ( cka_style ) cka.setAttribute( 'style', cka_style );

            editor.insertElement( cka );
        }
    };
});

