<?php
/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

if(in_array(ZONE, array('admin', 'membres')) && is_logged())
{
	if(isset($_GET['masquer_zone_recherche']))
	{
		sqlQuery("UPDATE " . sql_table('comptes_' . ZONE) . " SET masquer_zone_recherche = (masquer_zone_recherche % 2) + 1 WHERE id = '" . $auth[ZONE]['id'] . "'", __FILE__, __LINE__);

		$_SESSION['auth_' . ZONE]['masquer_zone_recherche'] = ($auth[ZONE]['masquer_zone_recherche'] == 'oui') ? 'non' : 'oui';

		redirect( preg_replace('#(&|\?)?masquer_zone_recherche(=1)?#', '', _REQUEST_URI) );
	}
}

$_HEADER = $_FOOTER = $_ASIDE = '';

$afficher_header = $afficher_header_nav = $afficher_footer = 0;

if(!is_null($_PAGE_PARAM['_CANONICAL']))
{
	$_PAGE_PARAM['_CANONICAL'] = html_entity_decode($_PAGE_PARAM['_CANONICAL'], ENT_QUOTES, 'UTF-8');

	if(preg_replace('#\?.+$#', '', _REQUEST_URI) != preg_replace('#\?.+$#', '', $_PAGE_PARAM['_CANONICAL']))
	{
		redirect($_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL']);
	}
}

if((ZONE == 'site' || is_private_area(ZONE)) && PAGE != 'imprimer')
{
	/* S'il y a plusieurs pager sur une même page */
	if(is_array($_LIMIT))
	{
		if(isset($show) && isset($_LIMIT[$show]) && isset(${'nbr_' . $show}))
		{
			if(${'nbr_' . $show} && $_LIMIT[$show] && $_PAGE > floor(${'nbr_' . $show} / $_LIMIT[$show]))
			{
				/* Renvoyer vers CANONICAL s'il est défini */
				redirect( is_null($_PAGE_PARAM['_CANONICAL']) ? uri(PAGE) : $_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL'] );
			}
		}
	}
	else
	{
		if($nbr_results && $_LIMIT && $_PAGE > floor($nbr_results / $_LIMIT))
		{
			redirect( is_null($_PAGE_PARAM['_CANONICAL']) ? uri(PAGE) : $_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL'] );
		}
	}

	if(ZONE == 'site')
	{
		if(LICENCE == 'H')
		{
			$_ASIDE = showAside($_CONFIG[LICENCE]['zone_laterale'], $idbox);
		}
		else
		{
			$_ASIDE = showAside($_CONFIG[LICENCE]['zone_laterale']);
		}
	}

	if(!is_private_area(ZONE) || $_CONFIG['backoffice']['utiliser_css_module'] == 'oui')
	{
		if(LICENCE == 'H')
		{
			$_HEADER = showHeader($_CONFIG[LICENCE]['header'], $idbox, 'site');
			$_FOOTER = showFooter($_CONFIG[LICENCE]['footer'], $idbox, 'site');
		}
		else
		{
			$_HEADER = showHeader($_CONFIG[LICENCE]['header'], 0, 'site');
			$_FOOTER = showFooter($_CONFIG[LICENCE]['footer'], 0, 'site');
		}

		$afficher_header = ($_CONFIG[LICENCE]['afficher_header'] == 'oui') ? 1 : 0;
		$afficher_header_nav = ($_CONFIG[LICENCE]['afficher_header_nav'] == 'oui') ? 1 : 0;
		$afficher_footer = ($_CONFIG[LICENCE]['afficher_footer'] == 'oui') ? 1 : 0;
	}
	else
	{
		$_HEADER = showHeader($_CONFIG['backoffice']['header'], 0, 'prive');
		$_FOOTER = showFooter($_CONFIG['backoffice']['footer'], 0, 'prive');

		$afficher_header = ($_CONFIG['backoffice']['afficher_header'] == 'oui') ? 1 : 0;
		$afficher_header_nav = ($_CONFIG['backoffice']['afficher_header_nav'] == 'oui') ? 1 : 0;
		$afficher_footer = ($_CONFIG['backoffice']['afficher_footer'] == 'oui') ? 1 : 0;
	}

	if(LICENCE == 'S' && $_CONFIG[LICENCE]['activer_newsletter'] == 'oui' && ZONE == 'site')
	{
		if(PAGE != 'newsletter')
		{
			$_ASIDE .= "<div id=\"_newsletter_form\">\n\t\t";

			$_ASIDE .= "<h3>" . fa_icon('newspaper-o') . " Newsletter</h3>\n\t\t";

			$_ASIDE .= "<p>Abonnez-vous pour être tenu informé de la publication de nos derniers articles.</p>\n\t\t";

			$Fields = $HiddenFields = array();

			$HiddenFields[] = form_input_hidden('referer', _REQUEST_URI);

			$Fields[] = array('entitled' => 'Votre adresse e-mail :',
							  'field' => form_input('email', '', 50, false, false, '', null, '', '', 'is-newsletter-form'),
							  'type' => 'input',
							  'width' => 'large',
							  'required' => true);

			$Fields[] = array('entitled' => 'Votre choix :',
							  'field' => array(form_radio('action', 'ajouter|Inscription', ((PAGE == 'newsletter' && $action == 'supprimer') ? 'supprimer' : 'ajouter'), '', false, 'is-newsletter-form'),
											   form_radio('action', 'supprimer|Désinscription', ((PAGE == 'newsletter' && $action == 'supprimer') ? 'supprimer' : 'ajouter'), '', false, 'is-newsletter-form')),
							  'type' => 'radio',
							  'required' => true);

			ob_start();

			create_form('Valider', uri('newsletter', '', _WEB_ROOT), false, 'POST', 'is-newsletter-form');

			$_ASIDE .= ob_get_clean();

			$_ASIDE .= "</div>\n\t\t";
		}
	}

	/* Fil d'Ariane */

	if(sizeof($_PAGE_PARAM['_BREADCRUMB']))
	{
		ksort($_PAGE_PARAM['_BREADCRUMB']);

		if($_CONFIG['site']['retour_site'] == 'non')
		{
			if(isset($_PAGE_PARAM['_BREADCRUMB'][0]) && $_PAGE_PARAM['_BREADCRUMB'][0]['url'] == uri('/'))
			{
				unset($_PAGE_PARAM['_BREADCRUMB'][0]);

				$_PAGE_PARAM['_BREADCRUMB'] = array_values($_PAGE_PARAM['_BREADCRUMB']);
			}
		}

		foreach($_PAGE_PARAM['_BREADCRUMB'] as $key => $enreg)
		{
			$_PAGE_PARAM['_BREADCRUMB'][$key] = '<li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">' . "\n\t\t";

			if(!$key)
			{
				$_PAGE_PARAM['_BREADCRUMB'][$key] .= fa_icon('home') . "&nbsp;\n\t\t";
			}

			$_PAGE_PARAM['_BREADCRUMB'][$key] .= '<a href="' . utf8entities($enreg['url']) . '" itemprop="item"><span itemprop="name">' . translate($enreg['title']) . '</span></a>';

			$_PAGE_PARAM['_BREADCRUMB'][$key] .= '<meta itemprop="position" content="' . ($key + 1) . '">';

			$_PAGE_PARAM['_BREADCRUMB'][$key] .= '</li>' . "\n";
		}
	}
}
elseif(PAGE == 'imprimer')
{
	$afficher_header = $afficher_footer = 1;
}

if(!is_private_area(ZONE) || $_CONFIG['backoffice']['utiliser_css_module'] == 'oui')
{
	$container_fluid = ($_CONFIG[LICENCE]['container_fluid'] == 'oui') ? true : false;
	$largeur_tableau = $_CONFIG[LICENCE]['largeur_tableau'];
}
else
{
	$container_fluid = ($_CONFIG['backoffice']['container_fluid'] == 'oui') ? true : false;
	$largeur_tableau = $_CONFIG['backoffice']['largeur_tableau'];
}

$afficher_zone_laterale = $_PAGE_PARAM['_LATERAL_NAV'] ? true : false;

if($largeur_tableau != '100%' && $largeur_tableau <= 850)
{
	$afficher_zone_laterale = false;
}

$_PAGE_PARAM['_LATERAL_NAV_LINKS'] = array();

if($afficher_zone_laterale)
{
	if(ZONE == 'admin' && is_logged() && PAGE != 'index')
	{
		$NavLinks = admin_access_sections();

		foreach($NavLinks as $key => $enreg)
		{
			if(strpos($enreg['intitule'], '*'))
			{
				unset($NavLinks[$key]);

				continue;
			}

			foreach($enreg['acces_sections'] as $key2 => $enreg2)
			{
				if(strpos($enreg2['titre'], '*'))
				{
					unset($NavLinks[$key]['acces_sections'][$key2]);
				}
			}

			if(!sizeof($NavLinks[$key]['acces_sections']))
			{
				unset($NavLinks[$key]);
			}
		}

		$cpt = 0;

		foreach($NavLinks as $enreg)
		{
			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt] = array();

			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['TITLE'] = $enreg['intitule'];
			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['ICON'] = fa_icon_migrate('fa fa-' . $enreg['fa-icon']);
			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['DATA'] = array();

			foreach($enreg['acces_sections'] as $key2 => $enreg2)
			{
				$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['DATA'][$key2] = $enreg2;
			}

			$cpt ++;
		}

		unset($NavLinks);
	}
	elseif(ZONE == 'site')
	{
		$result = sqlQuery("(SELECT id, titre, NULL AS texte, url, cible_lien, largeur_popup, hauteur_popup, icone, position
							 FROM " . sql_table('navigation_lien') . "
							 WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND zone = 'side' AND niveau = 1 AND id_pere = 0 AND (url IS NOT NULL OR nbr_liens_enfants <> 0))

							 UNION

							(SELECT id, titre, texte, null AS url, null AS cible_lien, 0 AS largeur_popup, 0 AS hauteur_popup, '' AS icone, position
							 FROM " . sql_table('zone_laterale_bloc') . "
							 WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND actif = 'oui' " . (!is_logged('admin') ? "AND admin_uniquement = 'non'" : "") . "
								AND date_debut <= NOW() AND (date_fin > NOW() OR date_fin = '0000-00-00 00:00:00'))

							ORDER BY (position <> 0) DESC, position, id", __FILE__, __LINE__);

		$cpt = 0;

		while($row = mysqli_fetch_array($result))
		{
			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt] = array();

			$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['TITLE'] = $row['titre'];

			if(is_null($row['texte']))
			{
				if(!is_null($row['url']))
				{
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['URL'] = $row['url'];
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['TARGET'] = $row['cible_lien'];
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['LARGEUR_POPUP'] = $row['largeur_popup'];
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['HAUTEUR_POPUP'] = $row['hauteur_popup'];
				}

				if(!empty($row['icone']))
				{
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['ICON'] = checkURL($row['icone']) ? '<img src="' . utf8entities($row['icone']) . '">' : 'fa fa-' . $row['icone'];
				}

				$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['DATA'] = array();

				$result2 = sqlQuery("SELECT SQL_CACHE id, titre, url, cible_lien, largeur_popup, hauteur_popup, icone
									 FROM " . sql_table('navigation_lien') . "
									 WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND zone = 'side' AND niveau = 2 AND id_pere = '" . $row['id'] . "'
									 ORDER BY (position <> 0) DESC, position, id", __FILE__, __LINE__);

				while($row2 = mysqli_fetch_array($result2))
				{
					$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['DATA'][$row2['url']] = array('cible_lien' => $row2['cible_lien'], 'largeur_popup' => $row2['largeur_popup'], 'hauteur_popup' => $row2['hauteur_popup'], 'titre' => $row2['titre']);
				}

				sqlFree($result2);
			}
			else
			{
				$_PAGE_PARAM['_LATERAL_NAV_LINKS'][$cpt]['DATA'] = $row['texte'];
			}

			$cpt ++;
		}

		sqlFree($result);
	}
}

$zone_membre_ok = false;

if(defined('_MBR_DIR'))
{
	if(in_array(LICENCE, array('M', 'P', 'O', 'R')))
	{
		if($_CONFIG[LICENCE]['activer_zone_membre'] == 'oui')
		{
			$zone_membre_ok = true;
		}
	}
	elseif(LICENCE == 'H')
	{
		if($_CONFIG[LICENCE]['ajout'] == 'oui' || $_CONFIG[LICENCE]['modification'] == 'oui' || $_CONFIG[LICENCE]['suppression'] == 'oui')
		{
			$zone_membre_ok = true;
		}
	}
	else
	{
		$zone_membre_ok = true;
	}
}

$_PAGE_PARAM['_NAV_LINKS'] = array();

if(in_array(ZONE, array('site', 'membres')) && $afficher_header_nav)
{
	$_PAGE_PARAM['_NAV_LINKS']['Niv1'] = $_PAGE_PARAM['_NAV_LINKS']['Niv2'] = $_PAGE_PARAM['_NAV_LINKS']['Niv3'] = array();

	if(LICENCE == 'S' && $_CONFIG[LICENCE]['navbar_categories'] == 'oui')
	{
		$result = sqlQuery("SELECT SQL_CACHE id, titre, icone, position FROM " . sql_table('cat', 'licence') . " WHERE nbr_pages <> 0", __FILE__, __LINE__);

		if(mysqli_num_rows($result))
		{
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][0] = array('titre' => translate('Les catégories'), 'url' => '', 'cible_lien' => '_self', 'largeur_popup' => 500, 'hauteur_popup' => 500, 'icone' => 'tags', 'nbr_liens_enfants' => 0);

			while($row = mysqli_fetch_array($result))
			{
				if(!isset($_PAGE_PARAM['_NAV_LINKS']['Niv2'][0]))
				{
					$_PAGE_PARAM['_NAV_LINKS']['Niv2'][0] = array();
				}

				$_PAGE_PARAM['_NAV_LINKS']['Niv2'][0][] = array('titre' => $row['titre'],
																'url' => uri('.', 'show=cat&idcat=' . $row['id'], _WEB_ROOT, false),
																'cible_lien' => '_self',
																'largeur_popup' => 500,
																'hauteur_popup' => 500,
																'icone' => '',
																'nbr_liens_enfants' => 0);

				$_PAGE_PARAM['_NAV_LINKS']['Niv1'][0]['nbr_liens_enfants'] ++;
			}

			sqlFree($result);
		}
	}

	$result = sqlQuery("SELECT SQL_CACHE id, id_pere, titre, url, cible_lien, largeur_popup, hauteur_popup, icone, nbr_liens_enfants
						FROM " . sql_table('navigation_lien') . "
						WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND zone = 'header' AND niveau IN(1, 2) AND (url IS NOT NULL OR nbr_liens_enfants <> 0)
						ORDER BY id_pere = 0, (position <> 0) DESC, position, id", __FILE__, __LINE__);

	while($row = mysqli_fetch_array($result))
	{
		if($row['id_pere'])
		{
			if(!isset($_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']]))
			{
				$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']] = array();
			}

			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']] = array();
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['titre'] = $row['titre'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['url'] = $row['url'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['cible_lien'] = $row['cible_lien'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['largeur_popup'] = $row['largeur_popup'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['hauteur_popup'] = $row['hauteur_popup'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['icone'] = $row['icone'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv2'][$row['id_pere']][$row['id']]['nbr_liens_enfants'] = $row['nbr_liens_enfants'];

			$result2 = sqlQuery("SELECT SQL_CACHE id, id_pere, titre, url, cible_lien, largeur_popup, hauteur_popup, icone
								 FROM " . sql_table('navigation_lien') . "
								 WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND id_pere = '" . $row['id'] . "' AND zone = 'header' AND niveau = 3 AND url IS NOT NULL
								 ORDER BY (position <> 0) DESC, position, id", __FILE__, __LINE__);

			while($row2 = mysqli_fetch_array($result2))
			{
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']] = array();
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['titre'] = $row2['titre'];
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['url'] = $row2['url'];
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['cible_lien'] = $row2['cible_lien'];
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['largeur_popup'] = $row2['largeur_popup'];
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['hauteur_popup'] = $row2['hauteur_popup'];
				$_PAGE_PARAM['_NAV_LINKS']['Niv3'][$row2['id_pere']][$row2['id']]['icone'] = $row2['icone'];
			}

			sqlFree($result2);
		}
		else
		{
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']] = array();
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['titre'] = $row['titre'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['url'] = $row['url'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['cible_lien'] = $row['cible_lien'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['largeur_popup'] = $row['largeur_popup'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['hauteur_popup'] = $row['hauteur_popup'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['icone'] = $row['icone'];
			$_PAGE_PARAM['_NAV_LINKS']['Niv1'][$row['id']]['nbr_liens_enfants'] = $row['nbr_liens_enfants'];
		}
	}

	sqlFree($result);
}

$_PAGE_PARAM['_FOOTER_LINKS'] = array();

if(ZONE == 'site' && $afficher_footer)
{
	$result = sqlQuery("SELECT SQL_CACHE id, id_pere, titre, url, cible_lien, largeur_popup, hauteur_popup, icone, nbr_liens_enfants
						FROM " . sql_table('navigation_lien') . "
						WHERE " . ((LICENCE == 'H') ? "id_module = '" . $idbox . "' AND" : "") . " licence = '" . LICENCE . "' AND zone = 'footer' AND niveau IN(1, 2) AND (url IS NOT NULL OR nbr_liens_enfants <> 0)
						ORDER BY (position <> 0) DESC, position, id", __FILE__, __LINE__);

	$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'] = $_PAGE_PARAM['_FOOTER_LINKS']['Niv2'] = array();

	while($row = mysqli_fetch_array($result))
	{
		if($row['id_pere'])
		{
			if(!isset($_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']]))
			{
				$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']] = array();
			}

			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']] = array();
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['titre'] = $row['titre'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['url'] = $row['url'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['cible_lien'] = $row['cible_lien'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['largeur_popup'] = $row['largeur_popup'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['hauteur_popup'] = $row['hauteur_popup'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv2'][$row['id_pere']][$row['id']]['icone'] = $row['icone'];
		}
		else
		{
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']] = array();
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['titre'] = $row['titre'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['url'] = $row['url'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['cible_lien'] = $row['cible_lien'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['largeur_popup'] = $row['largeur_popup'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['hauteur_popup'] = $row['hauteur_popup'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['icone'] = $row['icone'];
			$_PAGE_PARAM['_FOOTER_LINKS']['Niv1'][$row['id']]['nbr_liens_enfants'] = $row['nbr_liens_enfants'];
		}
	}

	sqlFree($result);
}

if($afficher_zone_laterale)
{
	if(LICENCE == 'S' && ZONE == 'site' && $_CONFIG[LICENCE]['afficher_dernier_commentaires'] == 'oui')
	{
		$result = sqlQuery("SELECT t1.id, t2.id AS id_page, t2.titre AS titre_page, t1.nom, commentaire, t1.date
							FROM " . sql_table('comment', 'licence') . " t1
							INNER JOIN " . sql_table('page', 'licence') . " t2 ON t2.id = id_page
							WHERE t1.actif = 'oui' AND t2.actif = 'oui'
							ORDER BY t1.date DESC
							LIMIT 10", __FILE__, __LINE__);

		$DerniersCommentaires = storeResult($result);
	}
}

if(!sizeof($_PAGE_PARAM['_LATERAL_NAV_LINKS']) && empty($_ASIDE) && !(LICENCE == 'S' && ZONE == 'site' && $_CONFIG[LICENCE]['afficher_dernier_commentaires'] == 'oui' && sizeof($DerniersCommentaires)))
{
	$afficher_zone_laterale = false;
}

/* Boutons de haut de page */

$HeaderButtons = array();

if(PAGE != 'imprimer')
{
	if(in_array(LICENCE, array('A', 'H', 'M', 'O', 'P', 'R', 'V')) && in_array(ZONE, array('site', 'membres')) && is_logged('membres') && $_CONFIG[LICENCE]['messagerie_privee'] == 'oui' && $auth['membres']['recevoir_messages_prives'] == 'oui')
	{
		$id_msg_supprimes = get_deleted_private_msg_list();

		$result = sqlQuery("SELECT COUNT(id)
							FROM " . sql_table('message_prive') . "
							WHERE id_dest LIKE '%," . $auth['membres']['id'] . ",%' AND lu NOT LIKE '%," . $auth['membres']['id'] . ",%'
								" . (!empty($id_msg_supprimes) ? "AND id NOT IN(" . $id_msg_supprimes . ")" : ""), __FILE__, __LINE__);

		list($nbr_nouveaux_messages_prives) = mysqli_fetch_row($result);

		if($nbr_nouveaux_messages_prives)
		{
			$HeaderButtons['nouveau_mp'] = '<a href="' . uri('messages-prives', '', _MBR_DIR) . '" class="btn btn-default btn-responsive-xs" title="' . translate("^\\0 nouveau[x] message[s] privé[s]$", array($nbr_nouveaux_messages_prives), true) . '">' . fa_icon('commenting-o') . ' <span class="hidden-xs">' . translate("^\\0 nouveau[x] message[s] privé[s]$", array($nbr_nouveaux_messages_prives), true) . '</span></a>';
		}
	}

	if(is_private_area(ZONE) && is_logged() && (ZONE == 'admin' || $zone_membre_ok))
	{
		$logout_redirect = in_array(LICENCE, array('F', 'K')) ? 'goto=' . urlencode(uri('/')) : '';

		$HeaderButtons['deconnexion'] = '<a href="' . uri('deconnexion', $logout_redirect, (ZONE == 'membres') ? _MBR_DIR : _ADMIN_DIR) . '" class="btn btn-danger btn-responsive-xs" title="' . translate("Déconnexion") . '">' . fa_icon('power-off') . ' <span class="hidden-xs">' . translate("Déconnexion") . '</span></a>';
	}
	elseif(PAGE != 'connexion' && in_array(ZONE, array('site', 'membres')) && $zone_membre_ok)
	{
		$HeaderButtons['connexion'] = '<a href="' . uri('connexion', '', _MBR_DIR) . '" class="btn btn-success btn-responsive-xs" target="' . $_CONFIG['commun']['cible_lien_boutons_header'] . '" title="' . translate(is_logged('membres') ? "Espace " . ((LICENCE == 'T') ? "clients" : "membres") : "Connexion") . '">' . fa_icon( is_logged('membres') ? 'user' : 'key' ) . ' <span class="hidden-xs">' . translate(is_logged('membres') ? "Espace " . ((LICENCE == 'T') ? "clients" : "membres") : "Connexion") . '</span></a>';
	}

	if(!is_logged('membres') && PAGE != 'inscription' && in_array(ZONE, array('site', 'membres')) && $_CONFIG['site']['creation_compte'] == 'oui' && $zone_membre_ok)
	{
		$HeaderButtons['inscription'] = '<a href="' . uri('inscription', '', _MBR_DIR) . '" class="btn btn-warning btn-responsive-xs" target="' . $_CONFIG['commun']['cible_lien_boutons_header'] . '" title="' . translate("Inscription") . '">' . fa_icon('pencil-square-o') . ' <span class="hidden-xs">' . translate("Inscription") . '</span></a>';
	}

	if(LICENCE == 'T' && in_array(ZONE, array('site', 'membres')))
	{
		$nbr_articles_panier = isset($_SESSION[LICENCE]['panier']) ? sizeof($_SESSION[LICENCE]['panier']) : 0;

		$HeaderButtons['panier'] = '<a href="' . uri('panier', '', _WEB_ROOT) . '" class="btn btn-default btn-responsive-xs" title="' . translate('Votre panier contient ^\\0 article[s]$', array($nbr_articles_panier), true) . '">' . fa_icon('shopping-cart') . ' <span class="hidden-xs">' . translate("Panier") . '</span></a>';

		$nbr_articles_panier = null;
	}
	elseif(LICENCE == 'O' && in_array(ZONE, array('site', 'membres')))
	{
		$HeaderButtons['selection'] = '<a href="' . uri('voir-annonces', 'show=selection', _WEB_ROOT) . '" class="btn btn-default btn-responsive-xs">' . fa_icon('star-o') . ' <span class="hidden-xs">' . translate("Ma sélection") . '</span></a>';
	}
}

if(!empty($_HEADER) && strpos($_HEADER, '[HEADER_BUTTONS') !== false)
{
	if(strpos($_HEADER, '[HEADER_BUTTONS=CENTER]') !== false)
	{
		$html = '<p class="text-center">';
	}
	elseif(strpos($_HEADER, '[HEADER_BUTTONS=LEFT]') !== false)
	{
		$html = '<p class="pull-left">';
	}
	else
	{
		$html = '<p class="pull-right" style="margin-right: 10px;">';
	}

	if(!$afficher_header)
	{
		if(sizeof($HeaderButtons))
		{
			$cpt = 1;

			foreach($HeaderButtons as $enreg)
			{
				$html .= $enreg;

				if($cpt < count($HeaderButtons))
				{
					$html .= '&nbsp;';
				}

				$cpt ++;
			}

			$HeaderButtons = array(); /* On vide l'array pour qu'il ne soit plus utilisés ailleurs dans la page */
		}

		$html .= '</p><div class="clearfix"></div>';
	}

	$_HEADER = preg_replace('#\[HEADER_BUTTONS[^\]]*\]#', $html, $_HEADER);

	unset($html);
}

sqlClose();
?>

<!DOCTYPE html>
<html lang="<?php echo _LANG; ?>" itemscope itemtype="https://schema.org/WebPage">

	<head>

		<?php if(ZONE == 'site' && PAGE == 'index'): ?>
		<title itemprop="name"><?php echo utf8entities(_SITE_TITLE) . (empty($_CONFIG['commun']['texte_header']) ? '' : ' - ' . utf8entities($_CONFIG['commun']['texte_header'])); ?></title>
		<?php else: ?>
		<title itemprop="name"><?php if($_PAGE_PARAM['_TITLE'] != _SITE_TITLE) echo utf8entities($_PAGE_PARAM['_TITLE']) . ' - '; echo utf8entities(_SITE_TITLE); ?></title>
		<?php endif; ?>

		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">

		<?php
		if(ZONE == 'site' && sizeof($_SITE_PARAM['_LANG'][0]) > 1)
		{
			foreach($_SITE_PARAM['_LANG'][0] as $code_langue => $nom_langue)
			{
		?>

			<link rel="alternate" hreflang="<?php echo $code_langue; ?>" href="<?php echo $_SITE_PARAM['_HTTP_SCHEME']; ?>://<?php echo _HTTP_HOST . _WEB_ROOT; ?>/<?php if($code_langue != 'fr') echo '?lng=' . $code_langue; ?>">

		<?php
			}
		}
		?>

		<?php if($_PAGE_PARAM['_META_ROBOTS'] != 'index, follow') echo '<meta name="Robots" content="' . $_PAGE_PARAM['_META_ROBOTS'] . '">'; ?>

		<meta itemprop="thumbnailUrl" content="https://wordpress.com/mshots/v1/<?php echo urlencode($_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . uri('.', '', _WEB_ROOT, false)); ?>?w=250">
		<meta itemprop="datePublished" content="<?php echo $_LICENCE[LICENCE]['DateAchat']; ?>">

		<meta name="viewport" content="user-scalable=yes, initial-scale=1, minimum-scale=1, maximum-scale=1, width=device-width">

		<?php
		if(!empty($_PAGE_PARAM['_META_DESCRIPTION']))
		{
			echo '<meta name="description" lang="' . _LANG . '" content="' . utf8entities($_PAGE_PARAM['_META_DESCRIPTION']) . '">' . "\n\n";
			echo '<meta itemprop="description" content="' . utf8entities($_PAGE_PARAM['_META_DESCRIPTION']) . '">' . "\n\n";
		}
		?>

		<?php if(!empty($_PAGE_PARAM['_META_KEYWORDS'])) echo '<meta name="' . ((LICENCE == 'H' && PAGE == 'fiche-actualite') ? 'news_keywords' : 'keywords') . '" lang="' . _LANG . '" content="' . utf8entities($_PAGE_PARAM['_META_KEYWORDS']) . '">' . "\n\n"; ?>

		<?php
		if(!is_null($_PAGE_PARAM['_CANONICAL']))
		{
			if(strpos($_PAGE_PARAM['_CANONICAL'], $_SITE_PARAM['_HTTP_SCHEME'] . '://') !== 0)
			{
				$_PAGE_PARAM['_CANONICAL'] = $_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL'];
			}

			echo '<link rel="canonical" href="' . utf8entities($_PAGE_PARAM['_CANONICAL']) . '">' . "\n\n";
			echo '<link itemprop="url" href="' . utf8entities($_PAGE_PARAM['_CANONICAL']) . '">' . "\n\n";
		}

		/* Favicon générale (défaut pour les modules de news) */
		$favicon = $_CONFIG['commun']['site_favicon'];

		/* Favicon du module de news */
		if(LICENCE == 'H' && !empty($_CONFIG[LICENCE]['favicon']))
		{
			$favicon = $_CONFIG[LICENCE]['favicon'];
		}

		if(!empty($favicon))
		{
			if(strpos($favicon, '.ico') !== false)
			{
				echo '<link rel="shortcut icon" type="image/x-icon" href="' . utf8entities($favicon) . '">' . "\n\n";
			}
			else
			{
				echo '<link rel="shortcut icon" type="image/png" href="' . utf8entities($favicon) . '">' . "\n\n";
			}
		}

		if(file_exists(_DOCUMENT_ROOT . '/apple-touch-icon-precomposed.png'))
		{
			echo '<link rel="apple-touch-icon-precomposed" href="' . _WEB_ROOT . '/apple-touch-icon-precomposed.png">' . "\n\n";
		}

		foreach(array('72x72', '114x114', '120x120', '152x152') as $size)
		{
			if(file_exists(_DOCUMENT_ROOT . '/apple-touch-icon-' . $size . '-precomposed.png'))
			{
				echo '<link rel="apple-touch-icon-precomposed" sizes="' . $size . '" href="' . _WEB_ROOT . '/apple-touch-icon-' . $size . '-precomposed.png">' . "\n\n";
			}
		}

		if(!is_null($_PAGE_PARAM['_RSS']))
		{
			if(!isset($_PAGE_PARAM['_RSS'][0]))
			{
				$_PAGE_PARAM['_RSS'] = array($_PAGE_PARAM['_RSS']);
			}

			for($i = 0 ; $i < count($_PAGE_PARAM['_RSS']) ; $i ++)
			{
				echo '<link rel="alternate" title="' . utf8entities($_PAGE_PARAM['_RSS'][$i]['title']) . '" href="' . utf8entities($_PAGE_PARAM['_RSS'][$i]['url']) . '" type="application/rss+xml">' . "\n\n";
			}
		}
		?>

		<?php
		/* https://developers.facebook.com/tools/debug/ */

		if(!isset($_PAGE_PARAM['_OG_LOGO']) || empty($_PAGE_PARAM['_OG_LOGO']))
		{
			$_PAGE_PARAM['_OG_LOGO'] = '';

			if(!empty($_CONFIG['commun']['logo_site']))
			{
				$_PAGE_PARAM['_OG_LOGO'] = $_CONFIG['commun']['logo_site'];
			}
		}

		if(!empty($_PAGE_PARAM['_OG_LOGO']))
		{
			$_PAGE_PARAM['_OG_WIDTH'] = $_PAGE_PARAM['_OG_HEIGHT'] = 0;

			$_og_logo_size = @getimagesize($_PAGE_PARAM['_OG_LOGO']);

			if(isset($_og_logo_size[0]) && $_og_logo_size[0])
			{
				$_PAGE_PARAM['_OG_WIDTH'] = $_og_logo_size[0];
			}

			if(isset($_og_logo_size[1]) && $_og_logo_size[1])
			{
				$_PAGE_PARAM['_OG_HEIGHT'] = $_og_logo_size[1];
			}

			if(!isset($_PAGE_PARAM['_OG_TITLE']) || empty($_PAGE_PARAM['_OG_TITLE']))
			{
				$_PAGE_PARAM['_OG_TITLE'] = $_PAGE_PARAM['_TITLE'];
			}

			if(!isset($_PAGE_PARAM['_OG_DESCRIPTION']) || empty($_PAGE_PARAM['_OG_DESCRIPTION']))
			{
				$_PAGE_PARAM['_OG_DESCRIPTION'] = $_PAGE_PARAM['_META_DESCRIPTION'];
			}

			if(!isset($_PAGE_PARAM['_OG_TYPE']))
			{
				$_PAGE_PARAM['_OG_TYPE'] = 'website';
			}
		?>

			<meta content="<?php echo utf8entities($_PAGE_PARAM['_OG_LOGO']); ?>" property="og:image">

			<meta content="<?php echo !is_null($_PAGE_PARAM['_CANONICAL']) ? utf8entities($_PAGE_PARAM['_CANONICAL']) : $_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST; ?>" property="og:url">

			<meta content="<?php echo utf8entities($_PAGE_PARAM['_OG_TITLE']); ?> - <?php echo utf8entities(_SITE_TITLE); ?>" property="og:title">

			<meta content="<?php echo utf8entities($_PAGE_PARAM['_OG_TYPE']); ?>" property="og:type">

			<meta content="<?php echo utf8entities($_PAGE_PARAM['_OG_DESCRIPTION']); ?>" property="og:description">

			<?php if($_PAGE_PARAM['_OG_WIDTH'] && $_PAGE_PARAM['_OG_HEIGHT']): ?>
			<meta content="<?php echo $_PAGE_PARAM['_OG_WIDTH']; ?>" property="og:image:width">
			<meta content="<?php echo $_PAGE_PARAM['_OG_HEIGHT']; ?>" property="og:image:height">
			<?php endif; ?>

		<?php
		}
		?>

		<!-- Bootstrap core CSS -->
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/bootstrap.min.css" media="screen">
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/bootstrap-extra.css" media="screen">
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/jquery.smartmenus.bootstrap.css" media="screen">

		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/fontawesome-all.min.css" media="screen">

		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/jQuery/jquery-ui.css" media="screen">

		<?php if(sizeof($_SITE_PARAM['_LANG'][0]) > 1) echo '<link rel="stylesheet" type="text/css" href="' . _CSS_DIR_BASE . '/bootstrap/languages.min.css" media="screen">'; ?>

		<!-- Custom styles -->
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-base.css" media="screen">
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-responsive.css" media="screen">

		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR; ?>/styles-<?php if(is_private_area(ZONE) && $_CONFIG['backoffice']['utiliser_css_module'] == 'non') echo 'prive'; else echo 'module'; ?>.css" media="screen">

		<?php if(PAGE == 'imprimer'): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-print.css" media="print">
		<?php endif; ?>

		<?php if(LICENCE == 'S' && ZONE == 'site' && PAGE != 'rechercher' && $_CONFIG[LICENCE]['calendrier_archives'] == 'oui'): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR; ?>/calendrier.css" media="screen">
		<?php endif; ?>

		<?php if(ZONE == 'site' && file_exists(_DOCUMENT_ROOT . '/css/styles-' . $_LICENCE[LICENCE]['NomCourt'] . '.css')): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR; ?>/styles-<?php echo $_LICENCE[LICENCE]['NomCourt']; ?>.css" media="screen">
		<?php endif; ?>

		<?php if(defined('FORMULAIRE') || defined('FILTRE_RECHERCHE')): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/jQuery/jquery.datetimepicker.css" media="screen">
		<?php endif; ?>

		<?php if(defined('FORMULAIRE') && $_CONFIG['commun']['captcha'] == 'calcul'): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/jQuery/jquery.calculator.css" media="screen">
		<?php endif; ?>

		<?php
		require_once _INC_PATH_BASE . '/extra_css.php';

		if(file_exists(_INC_PATH . '/extra_css.php'))
		{
			require_once _INC_PATH . '/extra_css.php';
		}

		if(is_array($fileCSS) && sizeof($fileCSS))
		{
			$fileCSS = array_unique($fileCSS);

			foreach($fileCSS as $file)
			{
				echo '<link rel="stylesheet" type="text/css" href="' . utf8entities($file) . '" media="screen">'."\n\t\t";
			}
		}

		if(isset($styleCSS) && !empty($styleCSS))
		{
			echo "\n\t\t".'<style type="text/css"><!--' . $styleCSS . "\t\t".'--></style>'."\n";
		}

		$CSS_CUSTOM = (is_private_area(ZONE) && $_CONFIG['backoffice']['utiliser_css_module'] == 'non') ? $_CONFIG['backoffice'] : $_CONFIG[LICENCE];
		?>

		<!-- jQuery -->
		<script type="text/javascript" src="<?php echo _JS_DIR_BASE; ?>/jQuery/jquery.core.min.js"></script>

		<?php if($_CONFIG['commun']['captcha'] == 'google') echo '<script type="text/javascript" src="https://www.google.com/recaptcha/api.js"></script>' . "\n\n"; ?>

		<script type="text/javascript">
		/* <![CDATA[ */
		<?php if(!empty($_SITE_PARAM['_DEV_KEY'])) echo '"use strict";' . "\n"; /* https://www.w3schools.com/js/js_strict.asp */ ?>

		var licence_url = '<?php echo $_SITE_PARAM['_HTTP_SCHEME']; ?>://<?php echo _HTTP_HOST . _WEB_ROOT; ?>/';
		var base_url = '<?php echo $_SITE_PARAM['_HTTP_SCHEME']; ?>://<?php echo _HTTP_HOST . _BASE; ?>/';
		/* ]]> */
		</script>

		<?php if(ZONE == 'site' && is_null($_SITE_PARAM['_DOMAINE_ALIAS']) && !empty($_CONFIG['commun']['google_analytics'])): ?>
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script type="text/javascript" async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $_CONFIG['commun']['google_analytics']; ?>"></script>
		<script type="text/javascript">
		  /* <![CDATA[ */
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?php echo $_CONFIG['commun']['google_analytics']; ?>');
		  /* ]]> */
		</script>
		<?php endif; ?>

	</head>

	<body>

		<a class="sr-only" href="#is-page"><?php echo translate("Aller au contenu"); ?></a>

		<div class="container<?php if($container_fluid) echo '-fluid'; ?>" <?php if(!$container_fluid) echo 'style="margin: 0 auto; max-width: ' . (($largeur_tableau == '100%') ? '100%' : $largeur_tableau . 'px') . ';"'; else echo 'style="margin: 0; padding: 0;"'; ?>>

			<?php if(!$afficher_header && !$afficher_header_nav): ?>

			<?php
			if(!empty($_HEADER))
			{
				echo '<div class="row">';

				echo '<div class="col-lg-12" style="background: ' . $CSS_CUSTOM['headerbgcolor'] . ';">';

				echo '<div style="padding: 0 10px;">';

				if(strpos($_HEADER, 'data-audio'))
				{
					$_HEADER = render_audio_responsive($_HEADER);
				}

				echo $_HEADER;

				echo '</div>';
			?>

				<?php if(msg(true)): ?>
				<div class="row">

					<div id="is-msg-box" class="col-lg-12" style="padding-top: 10px;">

						<?php echo msg(); ?>

					</div>

				</div>
				<?php endif; ?>

			<?php

				echo '</div>';

				echo '</div>';
			}
			else
			{
			?>

				<?php if(msg(true)): ?>
				<div class="row">

					<div id="is-msg-box" class="col-lg-12" style="padding-top: 10px;">

						<?php echo msg(); ?>

					</div>

				</div>
				<?php endif; ?>

			<?php
			}
			?>

			<?php else: ?>

			<header class="page-header" style="border: 0;">

				<?php
				if(!is_private_area(ZONE) || $_CONFIG['backoffice']['utiliser_css_module'] == 'oui')
				{
					$position_navbar = $_CONFIG[LICENCE]['position_navbar'];
				}
				else
				{
					$position_navbar = $_CONFIG['backoffice']['position_navbar'];
				}

				if($afficher_header_nav && $position_navbar == 'haut')
				{
				?>

					<div class="row">

						<div class="col-lg-12">

							<div class="navbar-wrapper">
								<?php include_once _INC_PATH_BASE . '/navigation.inc.php'; ?>
							</div>

						</div>

					</div>

				<?php
				}
				?>

				<?php if($afficher_header): ?>
				<div class="row is-header-main" <?php if($container_fluid) echo 'style="margin: 0 auto; max-width: ' . (($largeur_tableau == '100%') ? '100%' : $largeur_tableau . 'px') . ';"'; ?>>

					<div class="col-md-8" id="is-main-logo">

						<?php
						if(!empty($_CONFIG['commun']['logo_site']))
						{
							echo '<a href="' . uri('/') . '"><img src="' . utf8entities($_CONFIG['commun']['logo_site']) . '" alt="' . utf8entities(_SITE_TITLE) . '" itemprop="image" class="img-responsive-inline"></a>';
						}
						else
						{
							echo '<p class="h1"><a href="' . uri('/') . '">' . utf8entities(_SITE_TITLE) . '</a></p>';

							if(is_logged('admin') && _SITE_TITLE == 'Titre du site') echo '<p style="margin-left: 10px;">' . fa_icon('pencil') . ' <a href="' . uri('parametres-generaux', '', _ADMIN_DIR) . '">Editer le titre de votre site</a></p>';
						}

						if(!empty($_CONFIG['commun']['texte_header']))
						{
							echo '<p class="lead">' . utf8entities($_CONFIG['commun']['texte_header']) . '</p>';
						}
						?>

					</div>

					<?php if(PAGE != 'imprimer'): ?>
					<div class="col-md-4">

						<div class="row" style="margin-top: 10px; margin-bottom: 10px;">

							<div class="col-lg-12" <?php if($container_fluid) echo 'style="padding-right: 0;"'; ?>>

								<?php
								if(sizeof($HeaderButtons))
								{
									echo '<span class="pull-right" style="margin-right: 10px; white-space: nowrap;">';

									$cpt = 1;

									foreach($HeaderButtons as $enreg)
									{
										echo $enreg;

										if($cpt < count($HeaderButtons))
										{
											echo '&nbsp;';
										}

										$cpt ++;
									}

									echo '</span>';

									$HeaderButtons = array(); /* On vide l'array pour qu'il ne soit plus utilisés ailleurs dans la page */
								}
								?>

								<div class="clearfix"></div>

							</div>

							<?php if(ZONE == 'site' && sizeof($_SITE_PARAM['_LANG'][0]) > 1): ?>
							<div class="col-lg-12 hidden-sm hidden-xs">

								<?php echo select_langues(true); ?>

							</div>
							<?php endif; ?>

						</div>

					</div>
					<?php endif; ?>

				</div>
				<?php endif; ?>

				<?php
				if(!empty($_HEADER))
				{
					echo '<div class="row" style="background: inherit; ' . ($container_fluid ? 'margin: 0 auto; max-width: ' . (($largeur_tableau == '100%') ? '100%' : $largeur_tableau . 'px') . ';' : '') . '">';

					echo '<div class="col-lg-12" style="padding: 0;">';

					echo '<div style="padding: 10px;">';

					if(strpos($_HEADER, 'data-audio'))
					{
						$_HEADER = render_audio_responsive($_HEADER);
					}

					echo $_HEADER;

					echo '</div>';

					echo '</div>';

					echo '</div>';
				}
				?>

				<?php
				if(defined('DIAPORAMA_PHOTOS_HEADER'))
				{
					if(sizeof($Diaporama))
					{
						if(!$container_fluid)
						{
							echo '<div style="margin-left: -15px; margin-right: -15px;">';
						}

						echo render_slideshow($Diaporama, 'photo', $vitesse_diaporama, $transition_diaporama, $titre_diaporama);

						if(!$container_fluid)
						{
							echo '</div>';
						}
					}

					unset($Diaporama);
				}
				?>

				<?php if($afficher_header_nav && $position_navbar == 'bas'): ?>
				<div id="is-navigation">

					<div class="navbar-wrapper">
						<?php include_once _INC_PATH_BASE . '/navigation.inc.php'; ?>
					</div>

				</div>
				<?php endif; ?>

			</header>

			<?php endif; ?>

		</div>

		<div id="is-global" data-fontsize="<?php echo $_CONFIG[LICENCE]['fontsize']; ?>" class="container<?php if($container_fluid) echo '-fluid'; ?>" style="max-width: <?php echo ($largeur_tableau == '100%') ? '100%' : $largeur_tableau . 'px'; ?>;">

			<?php if(ZONE == 'site' && PAGE != 'imprimer'
						&& ((LICENCE == 'H' && !empty($_CONFIG[LICENCE]['banniere_haut']))
							|| (LICENCE != 'H' && !empty($_CONFIG['site']['banniere_haut'])))): ?>
			<div class="row hidden-xs is-margin-top-10">

				<div class="col-lg-12 is-banner-468x60 text-center">

					<?php echo $_CONFIG[(LICENCE == 'H') ? LICENCE : 'site']['banniere_haut']; ?>

				</div>

			</div>
			<?php endif; ?>

			<?php
			if($afficher_zone_laterale)
			{
				if(!is_private_area(ZONE) || $_CONFIG['backoffice']['utiliser_css_module'] == 'oui')
				{
					$position_zone_principale = ($_CONFIG[LICENCE]['position_zone_laterale'] == 'gauche') ? 'col-md-9 col-md-push-3' : 'col-md-9';
				}
				else
				{
					$position_zone_principale = ($_CONFIG['backoffice']['position_zone_laterale'] == 'gauche') ? 'col-md-9 col-md-push-3' : 'col-md-9';
				}
			}
			else
			{
				$position_zone_principale = 'col-lg-12';
			}
			?>

			<div class="row">

				<section id="is-page" class="<?php echo $position_zone_principale; ?>" role="main">

					<div class="row">

						<div class="col-lg-12 <?php if($afficher_header || $afficher_header_nav || !empty($_HEADER)) echo 'is-margin-top-15'; ?>">

							<?php if(($afficher_header || $afficher_header_nav) && msg(true)): ?>
							<div class="row">

								<div id="is-msg-box" class="col-lg-12">

									<?php echo msg(); ?>

								</div>

							</div>
							<?php endif; ?>

							<?php
							if(sizeof($_PAGE_PARAM['_BREADCRUMB']))
							{
								echo '<ul itemscope itemtype="https://schema.org/BreadcrumbList" class="breadcrumb" style="padding-top: 0; margin-bottom: 10px;">' . "\n\t\t";

								echo implode("", $_PAGE_PARAM['_BREADCRUMB']) . "\t\t";

								echo '<li class="active">' . utf8entities($_PAGE_PARAM['_TITLE']) . '</li>' . "\n\t\t";

								echo '</ul>' . "\n\t\t";
							}
							?>

							<h1 id="is-page-title">

								<?php if(is_private_area(ZONE)): ?>
								<span class="label label-default small" style="color: #fff; background: <?php echo module_color(); ?>;"><?php echo $_LICENCE[LICENCE]['Nom']; ?></span>
								<?php endif; ?>

								<?php echo utf8entities($_PAGE_PARAM['_TITLE']); ?>

							</h1>

							<?php if($afficher_header || $afficher_header_nav) echo '<hr>'; ?>

							<?php
							if(PAGE != 'imprimer')
							{
								if(sizeof($HeaderButtons) || (!$afficher_header_nav && ZONE != 'admin' && $_CONFIG['commun']['emplacement_lien_contact'] == 'header'))
								{
									echo '<p class="pull-right">';

									if(sizeof($HeaderButtons))
									{
										$cpt = 1;

										foreach($HeaderButtons as $enreg)
										{
											echo $enreg;

											if($cpt < count($HeaderButtons))
											{
												echo '&nbsp;';
											}

											$cpt ++;
										}
									}

									if(!$afficher_header_nav && ZONE != 'admin' && $_CONFIG['commun']['emplacement_lien_contact'] == 'header')
									{
							?>

									<a href="<?php echo uri('contact', ltrim($extra_module_param, '&'), _WEB_ROOT); ?>" target="<?php echo $_CONFIG['commun']['cible_lien_contact']; ?>" class="btn btn-primary btn-responsive-xs" title="<?php echo translate("Contactez-nous"); ?>"><?php echo fa_icon('envelope'); ?> <span class="hidden-xs"><?php echo translate("Contactez-nous"); ?></span></a>

							<?php
									}

									echo '</p>';
								}

								if((ZONE != 'site' || PAGE != 'index') && (!$afficher_header && !$afficher_header_nav) && $_CONFIG['site']['retour_site'] == 'oui')
								{
									echo '<p class="pull-left"><a href="' . uri('/') . '" class="btn btn-default" target="_top">' . fa_icon('hand-o-left') . ' ' . translate("Retour au site") . '</a></p>';
								}
							}

							echo '<div class="clearfix"></div>';
							?>

<?php
unset($_HEADER, $HeaderButtons, $CSS_CUSTOM);
?>