<?php
/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

define('HEADER_IFRAME', true);

if(!is_null($_PAGE_PARAM['_CANONICAL']))
{
	$_PAGE_PARAM['_CANONICAL'] = html_entity_decode($_PAGE_PARAM['_CANONICAL'], ENT_QUOTES, 'UTF-8');

	if(preg_replace('#\?.+$#', '', _REQUEST_URI) != preg_replace('#\?.+$#', '', $_PAGE_PARAM['_CANONICAL']))
	{
		redirect($_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL']);
	}
}

$container_fluid = false;

sqlClose();
?>

<!DOCTYPE html>
<html lang="fr">

	<head>

		<title><?php echo utf8entities($_PAGE_PARAM['_TITLE']); ?> - <?php echo utf8entities(_SITE_TITLE); ?></title>

		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<?php if($_PAGE_PARAM['_META_ROBOTS'] != 'index, follow') echo '<meta name="Robots" content="' . $_PAGE_PARAM['_META_ROBOTS'] . '">'; ?>

		<meta name="viewport" content="user-scalable=no, initial-scale=1, minimum-scale=1, maximum-scale=1, width=device-width">

		<?php
		if(!is_null($_PAGE_PARAM['_CANONICAL']))
		{
			if(strpos($_PAGE_PARAM['_CANONICAL'], $_SITE_PARAM['_HTTP_SCHEME'] . '://') !== 0)
			{
				$_PAGE_PARAM['_CANONICAL'] = $_SITE_PARAM['_HTTP_SCHEME'] . '://' . _HTTP_HOST . $_PAGE_PARAM['_CANONICAL'];
			}

			echo '<link rel="canonical" href="' . utf8entities($_PAGE_PARAM['_CANONICAL']) . '">' . "\n\n";
		}
		?>

		<!-- Bootstrap core CSS -->
		<link rel="stylesheet" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/bootstrap.min.css">

		<link rel="stylesheet" href="<?php echo _CSS_DIR_BASE; ?>/bootstrap/fontawesome-all.min.css">

		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-base-iframe.css" media="screen">
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-responsive-iframe.css" media="screen">

		<?php if(defined('FORMULAIRE') || defined('FILTRE_RECHERCHE')): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/jQuery/jquery.datetimepicker.css" media="screen">
		<?php endif; ?>

		<?php if(defined('FORMULAIRE') && $_CONFIG['commun']['captcha'] == 'calcul'): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/jQuery/jquery.calculator.css" media="screen">
		<?php endif; ?>

		<?php if(isset($_GET['print'])): ?>
		<link rel="stylesheet" type="text/css" href="<?php echo _CSS_DIR_BASE; ?>/styles-print.css" media="print">
		<?php endif; ?>

		<?php
		if(in_array(LICENCE, array('D', 'J', 'Q')) && !defined('MODAL'))
		{
			require_once _INC_PATH_BASE . '/extra_css-iframe.php'; /* Pop-up */
		}
		else
		{
			require_once _INC_PATH_BASE . '/extra_css.php'; /* Modal */
		}

		if(is_array($fileCSS) && sizeof($fileCSS))
		{
			foreach($fileCSS as $file)
			{
				echo '<link rel="stylesheet" type="text/css" href="' . utf8entities($file) . '" media="screen" />'."\n\t\t";
			}
		}

		if(isset($styleCSS) && !empty($styleCSS))
		{
			echo "\n\t\t".'<style type="text/css"><!--' . $styleCSS . "\t\t".'//--></style>'."\n";
		}
		?>

		<script type="text/javascript">
		/* <![CDATA[ */
		var licence_url = '<?php echo $_SITE_PARAM['_HTTP_SCHEME']; ?>://<?php echo _HTTP_HOST . _WEB_ROOT; ?>/';
		var base_url = '<?php echo $_SITE_PARAM['_HTTP_SCHEME']; ?>://<?php echo _HTTP_HOST . _BASE; ?>/';
		/* ]]> */
		</script>

		<!-- jQuery -->
		<script type="text/javascript" src="<?php echo _JS_DIR_BASE; ?>/jQuery/jquery.core.min.js"></script>

		<?php if(ZONE == 'site' && is_null($_SITE_PARAM['_DOMAINE_ALIAS']) && !empty($_CONFIG['commun']['google_analytics'])): ?>
		<!-- CODE GOOGLE ANALYTICS -->
		<script type="text/javascript">
		/* <![CDATA[ */
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

		  ga('create', '<?php echo $_CONFIG['commun']['google_analytics']; ?>', 'auto');
		  ga('send', 'pageview');
		/* ]]> */
		</script>
		<?php endif; ?>

	</head>

	<body <?php if(defined('MODAL')) echo 'style="background: #fff;"'; ?>>

		<div id="is-global" class="container-fluid">

			<div id="is-page">

				<div class="row">

					<div id="is-msg-box" class="col-lg-12 is-margin-top-15">

						<?php echo msg(); ?>

					</div>

					<div class="col-lg-12" style="padding-top: 10px;">

						<?php if(LICENCE == 'J' && PAGE == 'resultats' && !empty($_CONFIG['commun']['logo_site'])): ?>
						<div class="text-center"><img src="<?php echo utf8entities($_CONFIG['commun']['logo_site']); ?>" alt="<?php echo utf8entities(_SITE_TITLE); ?>" class="img-responsive-inline is-margin-bottom-10" style="max-width: 250px;"></div>
						<?php endif; ?>

						<?php if(LICENCE == 'D' && $_CONFIG[LICENCE]['afficher_titre'] == 'oui' && PAGE == 'index'): ?>
						<h1 style="margin-top: 0; font-size: 20px;"><?php echo utf8entities($_PAGE_PARAM['_TITLE']); ?></h1>
						<?php endif; ?>