<?php
/********************************************************************
	Auteur : Philippe Brouckaert
	Site de l'auteur : www.i-services.com
	Pour écrire à l'auteur : contact@i-services.net

	Copyright : Voir fichier licence.txt
*********************************************************************/

$CSS_CUSTOM = (is_private_area(ZONE) && $_CONFIG['backoffice']['utiliser_css_module'] == 'non') ? $_CONFIG['backoffice'] : $_CONFIG[LICENCE];

if(LICENCE != 'B' || ZONE != 'site')
{
	$CSS_CUSTOM['transparence'] = 'non';
}

if(!isset($CSS_CUSTOM['contbgcolor_alt']))
{
	$CSS_CUSTOM['contbgcolor_alt'] = $CSS_CUSTOM['contbgcolor'];
}

if(!isset($CSS_CUSTOM['contcolor_alt']))
{
	$CSS_CUSTOM['contcolor_alt'] = $CSS_CUSTOM['contcolor'];
}

if(!isset($CSS_CUSTOM['footerlinkcolor']))
{
	$CSS_CUSTOM['footerlinkcolor'] = $CSS_CUSTOM['footercolor'];
}
?>

<style type="text/css" media="screen">
<!--
body {
	font-size: <?php echo $CSS_CUSTOM['fontsize']; ?>px; <?php if(!defined('MODAL')) echo 'background-color: ' . ($container_fluid ? $CSS_CUSTOM['pagebgcolor'] : $CSS_CUSTOM['bgcolor']) . ';'; ?> color: <?php echo $CSS_CUSTOM['textcolor']; ?>;
	font-family: "<?php echo $CSS_CUSTOM['fontface']; ?>", "Helvetica Neue", Helvetica, Arial, sans-serif;

	<?php if(!empty($CSS_CUSTOM['papier_peint_fond'])): ?>
	background-image: url('<?php echo $CSS_CUSTOM['papier_peint_fond']; ?>');

		<?php if($CSS_CUSTOM['papier_peint_repete_hauteur'] == 'repeat' && $CSS_CUSTOM['papier_peint_repete_largeur'] == 'repeat'): ?>
		background-repeat: repeat;

		<?php elseif($CSS_CUSTOM['papier_peint_repete_hauteur'] == 'repeat'): ?>
		background-repeat: repeat-y;

		<?php elseif($CSS_CUSTOM['papier_peint_repete_largeur'] == 'repeat'): ?>
		background-repeat: repeat-x;

		<?php else: ?>
		background-repeat: no-repeat;

		<?php endif; ?>

	background-attachment: <?php echo $CSS_CUSTOM['papier_peint_fixe']; ?>;
	<?php endif; ?>
}

#is-global { background: <?php echo $CSS_CUSTOM['pagebgcolor']; ?>; <?php if($CSS_CUSTOM['transparence'] == 'oui') echo 'filter: alpha(opacity=70); opacity: .70;'; ?> }

<?php if($CSS_CUSTOM['bords_arrondis'] == 'non') echo 'form *, .navbar ul.dropdown-menu, .btn, .alert, .img-thumbnail, .thumbnail, .well, .jumbotron, .modal-content, .pagination, .pagination *, .form-control { border-radius: 0 !important; }'; ?>

/* COOKIE WARNING */

#is-cookie-warning {
	background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>;
	color: <?php echo $CSS_CUSTOM['contcolor']; ?>;
	border-top: 1px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?> !important;
}
#is-cookie-warning p { color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }

#is-cookie-warning button.close {
	background-color: <?php echo $CSS_CUSTOM['primarybutton_bgcolor']; ?>;
	color: <?php echo $CSS_CUSTOM['primarybutton_color']; ?>;
	border: 1px solid <?php echo $CSS_CUSTOM['primarybutton_bordercolor']; ?>;
}

/* NAVBAR */

.navbar-default {
	background-color: <?php echo $CSS_CUSTOM['navbarbgcolor']; ?>;

	border: 0; border-bottom: <?php echo $CSS_CUSTOM['navbarborderbottom']; ?>px solid <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
}
.navbar-default .navbar-brand {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
}
.navbar-default .navbar-brand:hover,
.navbar-default .navbar-brand:focus {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
	background-color: transparent;
}
.navbar-default .navbar-text {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
}
.navbar-default .navbar-nav > li > a {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
}
.navbar-default .navbar-nav > li > a:hover,
.navbar-default .navbar-nav > li > a:focus {
	color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>; /* Couleur des liens de 1er niveau (hover) */
	background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
}
.navbar-default .navbar-nav > .active > a,
.navbar-default .navbar-nav > .active > a:hover,
.navbar-default .navbar-nav > .active > a:focus {
	color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>;
	background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
}
.navbar-default .navbar-nav > .disabled > a,
.navbar-default .navbar-nav > .disabled > a:hover,
.navbar-default .navbar-nav > .disabled > a:focus {
	color: #ccc;
	background-color: transparent;
}

	/* Couleurs du bouton d'ouverture / fermeture du manu de navigation en mode mobile */

	.navbar-default .navbar-toggle {
		border-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
		background-color: <?php echo $CSS_CUSTOM['navbarbgcolor']; ?>;
	}
	.navbar-default .navbar-toggle:hover,
	.navbar-default .navbar-toggle:focus {
		background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
	}
	.navbar-default .navbar-toggle .icon-bar {
		background-color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
	}
	.navbar-default .navbar-toggle:hover .icon-bar,
	.navbar-default .navbar-toggle:focus .icon-bar {
		background-color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>;
	}

.navbar-default .navbar-collapse,
.navbar-default .navbar-form {
	border-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
}
.navbar-default .navbar-nav > .open > a,
.navbar-default .navbar-nav > .open > a:hover,
.navbar-default .navbar-nav > .open > a:focus {
	color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>; /* Couleur du lien actif de 1er niveau (quand menu niveau 2 déroulé) */
	background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
}

@media (max-width: 991px) {
  .navbar-default .navbar-nav .open .dropdown-menu > li > a {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
  }
  .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover,
  .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus {
    color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>; /* Couleur des liens de 2d niveau (hover) */
    background-color: transparent;
  }
  .navbar-default .navbar-nav .open .dropdown-menu > .active > a,
  .navbar-default .navbar-nav .open .dropdown-menu > .active > a:hover,
  .navbar-default .navbar-nav .open .dropdown-menu > .active > a:focus {
    color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>;
    background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
  }
  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a,
  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a:hover,
  .navbar-default .navbar-nav .open .dropdown-menu > .disabled > a:focus {
    color: #ccc;
    background-color: transparent;
  }
}

.navbar-default .navbar-link {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
}
.navbar-default .navbar-link:hover {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>; /* Couleur des liens de la barre de navigation hors onglets (hover) */
}
.navbar-default .btn-link {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>;
}
.navbar-default .btn-link:hover,
.navbar-default .btn-link:focus {
	color: <?php echo $CSS_CUSTOM['navbarcolor']; ?>; /* Couleur des liens-boutons de la barre de navigation (hover) */
}
.navbar-default .btn-link[disabled]:hover,
fieldset[disabled] .navbar-default .btn-link:hover,
.navbar-default .btn-link[disabled]:focus,
fieldset[disabled] .navbar-default .btn-link:focus {
	color: #ccc;
}
.navbar-form .btn {
	background-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['navbarbordercolor']; ?>;
	color: <?php echo $CSS_CUSTOM['navbartabcolor']; ?>;
}

<?php if(!empty($CSS_CUSTOM['img_navbar_home'])): ?>

	@media (min-width: 992px) {
		.topnav_home {
			background-image: url('<?php echo $CSS_CUSTOM['img_navbar_home']; ?>');
			background-repeat: no-repeat;
			background-position: 50% 46%;
			color: transparent !important;
			font-size: .01px !important;
			width: 50px;
		}
	}

<?php endif; ?>

.breadcrumb a, .breadcrumb a:hover, .breadcrumb a:focus { color: <?php echo $CSS_CUSTOM['breadcrumb_linkcolor']; ?>; }
.breadcrumb > li + li:before, .breadcrumb > .active { color: <?php echo $CSS_CUSTOM['breadcrumb_color']; ?>; }
.breadcrumb .fa-home { color: <?php echo $CSS_CUSTOM['breadcrumb_iconcolor']; ?>; }

#is-lateral-area .is-lateral-area-inner { background: <?php echo $CSS_CUSTOM['aside_color']; ?>; padding: 0 5px 5px 10px; }

.page-header { border-bottom-color: <?php echo $CSS_CUSTOM['header_baselinecolor']; ?>; background-color: <?php echo $CSS_CUSTOM['headerbgcolor']; ?>; }
.page-header .lead { font-size: <?php echo $CSS_CUSTOM['fontsize']; ?>px; }
.page-header .is-header-main { background-color: <?php if($CSS_CUSTOM['header_transparent'] == 'oui') echo 'transparent'; else echo $CSS_CUSTOM['headerbgcolor']; ?>; height: 100%; }

<?php if(!empty($CSS_CUSTOM['papier_peint_header'])): ?>

	.page-header .is-header-main { background-image: url('<?php echo $CSS_CUSTOM['papier_peint_header']; ?>'); background-repeat: no-repeat; background-position: left bottom; background-size: cover; }

	@media (min-width: 992px) {
		.page-header .is-header-main {
			height: 200px; background-size: auto;
		}
	}

<?php endif; ?>

.is-header-main { color: <?php echo $CSS_CUSTOM['headercolor']; ?>; }

h1 { color: <?php echo $CSS_CUSTOM['titlecolor']; ?>; }

#is-global hr { border-color: <?php echo $CSS_CUSTOM['header_baselinecolor']; ?>; }

a, a.btn-link { color: <?php echo $CSS_CUSTOM['linkcolor_out']; ?>; }
a:hover, a:focus, a.btn-link:hover, a.btn-link:focus { color: <?php echo $CSS_CUSTOM['linkcolor_out']; ?>; }

.is-list-icons li .fa, .is-list-icons li .fas, .is-list-icons li .far, .is-list-icons li .fal, .is-list-icons li .fab { color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }

code { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }

table.table thead { background: <?php echo $CSS_CUSTOM['table_headbgcolor']; ?>; color: <?php echo $CSS_CUSTOM['table_headcolor']; ?>; }
.table-striped > tbody > tr:nth-of-type(odd) { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }
.table-striped > tbody > tr:nth-of-type(even) { background-color: <?php echo $CSS_CUSTOM['contbgcolor_alt']; ?>; color: <?php echo $CSS_CUSTOM['contcolor_alt']; ?>; }
.table-hover > tbody > tr:hover { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }

.table-striped > tbody > tr:nth-of-type(odd) a, .table-hover > tbody > tr:hover a,
table:not(.table-striped) > tbody > tr:nth-of-type(odd) a { color: <?php echo $CSS_CUSTOM['linkcolor_in']; ?>; }

table:not(.table-striped) tbody tr { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; color: <?php echo $CSS_CUSTOM['contcolor']; ?>; }

pre { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?> !important; color: <?php echo $CSS_CUSTOM['contcolor']; ?>; border-color: <?php echo $CSS_CUSTOM['contbordercolor']; ?> !important; }

#is-page .well { background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?> !important; border: 1px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?> !important; }

#is-page .well .well { background-color: <?php echo $CSS_CUSTOM['pagebgcolor']; ?> !important; border: 1px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?> !important; }

#is-page .well label, #is-page .well h2, #is-page .well .control-label, #is-page .well .form-control-static, #is-page div.well p, #is-page div.well li, article.well p, article.well li, form.well legend { color: <?php echo $CSS_CUSTOM['contcolor']; ?> !important; }
#is-page .well kbd { background-color: <?php echo $CSS_CUSTOM['contbordercolor']; ?> !important; border: 1px solid <?php echo $CSS_CUSTOM['contbgcolor']; ?> !important; color: <?php echo $CSS_CUSTOM['contcolor']; ?> !important; }
#is-page .well .help-block { color: <?php echo ($CSS_CUSTOM['contcolor'] != '#333333') ? $CSS_CUSTOM['contcolor'] : '#737373'; ?> !important; }
#is-page .well a, #is-page .well a.btn-link { color: <?php echo $CSS_CUSTOM['linkcolor_in']; ?>; }
#is-page .well a:hover, #is-page .well a:focus, #is-page .well a.btn-link:hover, #is-page .well a.btn-link:focus { color: <?php echo $CSS_CUSTOM['linkcolor_in']; ?>; }

<?php if(LICENCE == 'O'): ?>
#is-page .well.bg-premium { background-color: <?php echo $_CONFIG[LICENCE]['premium_bgcolor']; ?> !important; border-color: <?php echo $_CONFIG[LICENCE]['premium_bordercolor']; ?>; }
#is-page .well.bg-premium h2, #is-page .well.bg-premium h3 { color: <?php echo $_CONFIG[LICENCE]['premium_titlecolor']; ?> !important; }
<?php endif; ?>

blockquote { border-left: 5px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?>; background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?> !important; }
blockquote.to-right { margin-left: 10px; border-left: 0; border-right: 5px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?>; }

blockquote.is-quote { background-color: <?php echo $CSS_CUSTOM['pagebgcolor']; ?>; color: <?php echo $CSS_CUSTOM['textcolor']; ?>; border-color: <?php echo $CSS_CUSTOM['contbordercolor']; ?>; }
details.spoiler main { background-color: <?php echo $CSS_CUSTOM['pagebgcolor']; ?>; color: <?php echo $CSS_CUSTOM['textcolor']; ?>; }

::-moz-selection { background-color: <?php echo $CSS_CUSTOM['contcolor']; ?>; color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; }
::-webkit-selection { background-color: <?php echo $CSS_CUSTOM['contcolor']; ?>; color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; }
::selection { background-color: <?php echo $CSS_CUSTOM['contcolor']; ?>; color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; }

input::-moz-selection, textarea::-moz-selection { background-color: #333 !important; color: #fff !important; }
input::-webkit-selection, textarea::-webkit-selection { background-color: #333 !important; color: #fff !important; }
input::selection, textarea::selection { background-color: #333 !important; color: #fff !important; }

div.thumbnail {
	background-color: <?php echo $CSS_CUSTOM['contbgcolor']; ?>; border: 1px solid <?php echo $CSS_CUSTOM['contbordercolor']; ?>;
}

div.thumbnail .caption * {
	color: <?php echo $CSS_CUSTOM['contcolor']; ?>;
}

/* ONGLETS DES FICHES */

.panel {
	background-color: transparent;
}

.nav-tabs > li > a,
.panel-default>.panel-heading {
	color: <?php echo $CSS_CUSTOM['defaultbutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['defaultbutton_bgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['defaultbutton_bordercolor']; ?>;
}
.nav-tabs > li > a:hover,
.nav-tabs > li > a:focus {
	color: <?php echo $CSS_CUSTOM['defaultbutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbordercolor']; ?>;
}
.nav-tabs > li.active > a,
.nav-tabs > li.active > a:hover,
.nav-tabs > li.active > a:focus {
	color: <?php echo $CSS_CUSTOM['defaultbutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbordercolor']; ?>;
}

/* PAGINATION */

.pagination > li > a,
.pagination > li > span {
	color: <?php echo $CSS_CUSTOM['defaultbutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['defaultbutton_bgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['defaultbutton_bordercolor']; ?>;
}
.pagination > li > a:hover,
.pagination > li > span:hover,
.pagination > li > a:focus,
.pagination > li > span:focus {
	color: <?php echo $CSS_CUSTOM['defaultbutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['defaultbutton_hoverbordercolor']; ?>;
}
.pagination > .active > a,
.pagination > .active > span,
.pagination > .active > a:hover,
.pagination > .active > span:hover,
.pagination > .active > a:focus,
.pagination > .active > span:focus {
	color: <?php echo $CSS_CUSTOM['primarybutton_color']; ?>;
	background-color: <?php echo $CSS_CUSTOM['primarybutton_hoverbgcolor']; ?>;
	border-color: <?php echo $CSS_CUSTOM['primarybutton_hoverbordercolor']; ?>;
}

#is-footer { background-color: <?php echo $CSS_CUSTOM['pagebgcolor']; ?>; }

#is-footer footer div.is-footer-inner { background-color: <?php echo $CSS_CUSTOM['footerbgcolor']; ?>; }

#is-footer footer * { color: <?php echo $CSS_CUSTOM['footercolor']; ?>; }
#is-footer footer a, #is-footer footer a:visited, #is-footer footer a:active, #is-footer footer a:hover { color: <?php echo $CSS_CUSTOM['footerlinkcolor']; ?>; }

<?php
foreach(array('primary', 'success', 'default', 'warning', 'danger') as $enreg)
{
?>

	.btn-<?php echo $enreg; ?> {
		color: <?php echo $CSS_CUSTOM[$enreg . 'button_color']; ?> !important;
		background-color: <?php echo $CSS_CUSTOM[$enreg . 'button_bgcolor']; ?> !important;
		border-color: <?php echo $CSS_CUSTOM[$enreg . 'button_bordercolor']; ?> !important;
	}

	.btn-<?php echo $enreg; ?>:hover, .btn-<?php echo $enreg; ?>:focus, .btn-<?php echo $enreg; ?>.focus, .btn-<?php echo $enreg; ?>:active, .btn-<?php echo $enreg; ?>.active {
		color: <?php echo $CSS_CUSTOM[$enreg . 'button_color']; ?> !important;
		background-color: <?php echo $CSS_CUSTOM[$enreg . 'button_hoverbgcolor']; ?> !important;
		border-color: <?php echo $CSS_CUSTOM[$enreg . 'button_hoverbordercolor']; ?> !important;
	}

<?php
}
?>

<?php if(LICENCE != 'B'):
/*
Ne plus utiliser cette partie ni ces classes, progressivement, et utiliser classe .content-img-responsive sur DIV parent directement dans les pages où s'affichent les images
Voir fonction format_module_text()
*/
?>
img.is-img-txt:not(.img-responsive), img.is-img-left:not(.img-responsive), img.is-img-right:not(.img-responsive), .is-img-bottom:not(.img-responsive), .is-img-top:not(.img-responsive)
{
	max-width: 100%;
	height: auto !important;
}

@media (min-width: 500px) {
	img.is-img-txt:not(.img-responsive), img.is-img-left:not(.img-responsive), img.is-img-right:not(.img-responsive)
	{
		<?php if(in_array(LICENCE, array('A', 'D'))): ?>
		max-width: <?php echo ($_CONFIG[LICENCE]['largeur_image'] < 500) ? $_CONFIG[LICENCE]['largeur_image'] . 'px' : '90%'; ?>;

		<?php elseif(LICENCE == 'R'): ?>
		max-width: 450px;

		<?php elseif(LICENCE == 'M'): ?>
		max-width: <?php echo (ZONE != 'site' || PAGE == 'fiche-site') ? $_CONFIG[LICENCE]['largeur_miniature'] : min($_CONFIG[LICENCE]['largeur_miniature'], 180); ?>px;

		<?php elseif(LICENCE == 'O'): ?>
		max-width: <?php echo (in_array(PAGE, array('fiche-annonce', 'ajouter-annonce', 'modifier-annonce'))) ? 400 : 200; ?>px;
		max-height: <?php echo (in_array(PAGE, array('fiche-annonce', 'ajouter-annonce', 'modifier-annonce'))) ? 300 : 200; ?>px;

		<?php elseif(LICENCE == 'T'): ?>
		max-width: <?php echo (ZONE != 'site' || strpos(PAGE, 'fiche-') === 0) ? 400 : 260; ?>px;
		max-height: <?php echo (ZONE != 'site' || strpos(PAGE, 'fiche-') === 0) ? 300 : 260; ?>px;

		<?php elseif(!in_array(LICENCE, array('H', 'S')) || $_CONFIG['commun']['ckeditor'] == 'non'): ?>

		max-width: 400px;

		<?php endif; ?>
	}

	.is-img-bottom:not(.img-responsive), .is-img-top:not(.img-responsive)
	{
		<?php if(in_array(LICENCE, array('D'))): ?>
		max-width: <?php echo ($_CONFIG[LICENCE]['largeur_image'] < 500) ? $_CONFIG[LICENCE]['largeur_image'] . 'px' : '90%'; ?>;

		<?php elseif(!in_array(LICENCE, array('H', 'S')) || $_CONFIG['commun']['ckeditor'] == 'non'): ?>

		max-width: 400px;

		<?php endif; ?>
	}
}
<?php else: /* A utiliser progressivement */ ?>

.content-img-responsive img {
	max-width: 100%;
	height: auto !important;
}

@media (min-width: 500px) {
	.content-img-responsive img {
		<?php if(in_array(LICENCE, array('A', 'D'))): ?>
		max-width: <?php echo ($_CONFIG[LICENCE]['largeur_image'] < 500) ? $_CONFIG[LICENCE]['largeur_image'] . 'px' : '100%'; ?>;

		<?php elseif(LICENCE == 'M'): ?>
		max-width: <?php echo (ZONE != 'site' || PAGE == 'fiche-site') ? $_CONFIG[LICENCE]['largeur_miniature'] : min($_CONFIG[LICENCE]['largeur_miniature'], 180); ?>px;

		<?php elseif(LICENCE == 'O'): ?>
		max-width: <?php echo (in_array(PAGE, array('fiche-annonce', 'ajouter-annonce', 'modifier-annonce'))) ? 400 : 200; ?>px;
		max-height: <?php echo (in_array(PAGE, array('fiche-annonce', 'ajouter-annonce', 'modifier-annonce'))) ? 300 : 200; ?>px;

		<?php elseif(LICENCE == 'T'): ?>
		max-width: <?php echo (ZONE != 'site' || strpos(PAGE, 'fiche-') === 0) ? 400 : 260; ?>px;
		max-height: <?php echo (ZONE != 'site' || strpos(PAGE, 'fiche-') === 0) ? 300 : 260; ?>px;

		<?php elseif(!in_array(LICENCE, array('H', 'S')) || $_CONFIG['commun']['ckeditor'] == 'non'): ?>

		/* max-width: 450px; */

		<?php endif; ?>
	}
}
<?php endif; ?>

-->
</style>

<?php
unset($CSS_CUSTOM);

if(defined('CSS_LISTE_RESPONSIVE'))
{
	$cpt = (LICENCE == 'I' && in_array(PAGE, array('cartes', 'personnaliser'))) ? $nbr_cartes : $nbr_categories;

	/* Liste des catégories sous forme de vignettes (responsive) */

	$styleCSS .= '.is-img-cat { max-height: 150px; }

				  @media (min-width: 768px) {
					  .is-img-cat { max-height: 180px; }
				  }' . "\n\t\t";

	$styleCSS .= '.is-cat-bloc > img { max-height: 100px; max-width: 100px; }
				  .is-cat-bloc dd { padding-top: 5px }' . "\n\t\t";

	$styleCSS .= '@media (max-width: 767px) {
					  .is-cat-bloc dd ul li { display: inline !important; margin-right: 5px; }
				  }' . "\n\t\t";

	if($_CONFIG[LICENCE]['nbr_col'] >= 2)
	{
		$styleCSS .= '@media (max-width: 767px) {' . "\n\t\t";

		for($i = 3 ; $i <= $cpt ; $i += 2)
		{
			$styleCSS .= '#_categories.sans-description .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; } }' . "\n\t\t";
	}

	if($_CONFIG[LICENCE]['nbr_col'] == 2)
	{
		$styleCSS .= '@media (min-width: 768px) {' . "\n\t\t";

		for($i = 3 ; $i <= $cpt ; $i += 2)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; }' . "\n\t\t";

		$styleCSS .= '}' . "\n\t\t";
	}
	elseif($_CONFIG[LICENCE]['nbr_col'] == 3)
	{
		$styleCSS .= '@media (min-width: 768px) {' . "\n\t\t";

		for($i = 4 ; $i <= $cpt ; $i += 3)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; }' . "\n\t\t";

		$styleCSS .= '}' . "\n\t\t";
	}
	elseif($_CONFIG[LICENCE]['nbr_col'] == 4)
	{
		$styleCSS .= '@media (min-width: 768px) AND (max-width: 991px) {' . "\n\t\t";

		for($i = 4 ; $i <= $cpt ; $i += 3)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; } }' . "\n\t\t";

		$styleCSS .= '@media (min-width: 992px) {' . "\n\t\t";

		for($i = 5 ; $i <= $cpt ; $i += 4)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; }' . "\n\t\t";

		$styleCSS .= '}' . "\n\t\t";
	}
	elseif($_CONFIG[LICENCE]['nbr_col'] == 6)
	{
		$styleCSS .= '@media (min-width: 768px) AND (max-width: 991px) {' . "\n\t\t";

		for($i = 4 ; $i <= $cpt ; $i += 3)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; } }' . "\n\t\t";

		$styleCSS .= '@media (min-width: 992px) AND (max-width: 1199px) {' . "\n\t\t";

		for($i = 5 ; $i <= $cpt ; $i += 4)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; } }' . "\n\t\t";

		$styleCSS .= '@media (min-width: 1200px) {' . "\n\t\t";

		for($i = 7 ; $i <= $cpt ; $i += 6)
		{
			$styleCSS .= '#_categories .cpt-cat-' . $i . ', ';
		}

		$styleCSS = rtrim($styleCSS, ', ');

		$styleCSS .= '{ clear: left; }' . "\n\t\t";

		$styleCSS .= '}' . "\n\t\t";
	}
}
?>